/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.internal.markers;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.editor.MavenEditorImages;
import org.eclipse.m2e.editor.internal.markers.AbstractPomProblemResolution;
import org.eclipse.m2e.editor.internal.markers.MavenMarkerResolutionGenerator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;

public class IgnoreWarningResolution
extends AbstractPomProblemResolution {
    private final String markupText;

    public IgnoreWarningResolution(IMarker marker, String markupText) {
        super(marker);
        this.markupText = markupText;
    }

    public int getOrder() {
        return 200;
    }

    @Override
    public boolean canFix(String editorHint) {
        return MavenMarkerResolutionGenerator.isDependencyVersionOverride(editorHint) || MavenMarkerResolutionGenerator.isPluginVersionOverride(editorHint);
    }

    public String getLabel() {
        return "Ignore this warning";
    }

    public Image getImage() {
        return MavenEditorImages.IMG_CLOSE;
    }

    public String getDescription() {
        if (this.getQuickAssistContext() != null) {
            IDOMModel domModel = null;
            try {
                IDocument doc = this.getQuickAssistContext().getSourceViewer().getDocument();
                domModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(doc);
                int line = doc.getLineOfOffset(this.getQuickAssistContext().getOffset());
                int linestart = doc.getLineOffset(line);
                int lineend = linestart + doc.getLineLength(line);
                int start = linestart;
                IndexedRegion reg = domModel.getIndexedRegion(start);
                while (reg != null && !(reg instanceof Element) && start < lineend) {
                    if ((reg = domModel.getIndexedRegion(reg.getEndOffset() + 1)) == null) continue;
                    start = reg.getStartOffset();
                }
                if (reg instanceof Element) {
                    String currentLine = StringUtils.convertToHTMLContent((String)doc.get(reg.getStartOffset(), reg.getEndOffset() - reg.getStartOffset()));
                    String insert = StringUtils.convertToHTMLContent((String)("<!--" + this.markupText + "-->"));
                    String string = "<html>...<br>" + currentLine + "<b>" + insert + "</b><br>...<html>";
                    return string;
                }
            }
            catch (BadLocationException e1) {
                this.LOG.error("Error while computing completion proposal", (Throwable)e1);
            }
            finally {
                if (domModel != null) {
                    domModel.releaseFromRead();
                }
            }
        }
        return "Adds comment markup next to the affected element. No longer shows the warning afterwards";
    }

    @Override
    protected void processFix(IStructuredDocument doc, Element root, List<IMarker> markers) {
        for (IMarker marker : markers) {
            IDOMModel domModel = null;
            try {
                int line;
                domModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)doc);
                if (this.getQuickAssistContext() != null) {
                    line = doc.getLineOfOffset(this.getQuickAssistContext().getOffset());
                } else {
                    line = marker.getAttribute("lineNumber", -1);
                    assert (line != -1);
                    --line;
                }
                try {
                    int linestart = doc.getLineOffset(line);
                    int lineend = linestart + doc.getLineLength(line);
                    int start = linestart;
                    IndexedRegion reg = domModel.getIndexedRegion(start);
                    while (reg != null && !(reg instanceof Element) && start < lineend) {
                        if ((reg = domModel.getIndexedRegion(reg.getEndOffset() + 1)) == null) continue;
                        start = reg.getStartOffset();
                    }
                    if (!(reg instanceof Element)) continue;
                    InsertEdit edit = new InsertEdit(reg.getEndOffset(), "<!--" + this.markupText + "-->");
                    try {
                        edit.apply((IDocument)doc);
                        marker.delete();
                    }
                    catch (Exception e) {
                        this.LOG.error("Unable to insert", (Throwable)e);
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                if (domModel != null) {
                    domModel.releaseFromRead();
                }
            }
        }
    }
}

