/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextComputationStrategy;
import org.eclipse.osgi.util.NLS;

public class StrategiesExtensionPointReader {
    private static final String CONTEXT_COMPUTATION_STRATEGY = "contextComputationStrategy";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String STRATEGIES_EXTENSION_POINT_ID = "org.eclipse.mylyn.context.core.strategies";

    public static List<ContextComputationStrategy> readContextComputationStrategies() {
        IExtension[] extensions;
        ArrayList<ContextComputationStrategy> strategies = new ArrayList<ContextComputationStrategy>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(STRATEGIES_EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurationElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
            int n3 = configurationElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(CONTEXT_COMPUTATION_STRATEGY)) {
                    try {
                        ContextComputationStrategy strategy = (ContextComputationStrategy)element.createExecutableExtension(ATTRIBUTE_CLASS);
                        strategies.add(strategy);
                    }
                    catch (Throwable t) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", NLS.bind((String)"Cannot instantiate {0} from bundle {1}: {2}", (Object[])new String[]{element.getAttribute(ATTRIBUTE_CLASS), extension.getContributor().getName(), t.getMessage()}), t));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return strategies;
    }
}

