/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.graph.figures.primitives;

import com.google.inject.Inject;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.xtext.ui.graph.figures.layouts.RailroadConnectionRouter;
import org.eclipse.xtext.xtext.ui.graph.figures.primitives.AbstractNode;
import org.eclipse.xtext.xtext.ui.graph.figures.primitives.Connection;
import org.eclipse.xtext.xtext.ui.graph.figures.primitives.CrossPoint;
import org.eclipse.xtext.xtext.ui.graph.figures.primitives.ErrorNode;
import org.eclipse.xtext.xtext.ui.graph.figures.primitives.LabelNode;
import org.eclipse.xtext.xtext.ui.graph.figures.primitives.NodeType;
import org.eclipse.xtext.xtext.ui.graph.figures.primitives.RectangleNode;
import org.eclipse.xtext.xtext.ui.graph.figures.primitives.RoundedNode;

public class PrimitiveFigureFactory {
    @Inject
    private RailroadConnectionRouter connectionRouter;
    private Font font;

    public AbstractNode createNode(NodeType nodeType, EObject eObject, String name, IFigure containerFigure, Region textRegion) {
        AbstractNode node = this.newNode(nodeType, eObject, name, textRegion);
        containerFigure.add((IFigure)node);
        return node;
    }

    public CrossPoint createCrossPoint(IFigure containerFigure) {
        CrossPoint crossPoint = new CrossPoint();
        containerFigure.add((IFigure)crossPoint);
        return crossPoint;
    }

    public Connection createConnection(CrossPoint source, CrossPoint target, IFigure containerFigure) {
        Connection connection = new Connection(source, target);
        containerFigure.add((IFigure)connection);
        connection.setConnectionRouter((ConnectionRouter)this.connectionRouter);
        return connection;
    }

    public Connection createConnection(CrossPoint source, CrossPoint target, IFigure containerFigure, RailroadConnectionRouter.BendConstraint bendConstraint) {
        Connection connection = new Connection(source, target);
        containerFigure.add((IFigure)connection);
        connection.setConnectionRouter((ConnectionRouter)this.connectionRouter);
        this.connectionRouter.setConstraint((org.eclipse.draw2d.Connection)connection, bendConstraint);
        return connection;
    }

    protected AbstractNode newNode(NodeType type, EObject eObject, String text, Region textRegion) {
        switch (type) {
            case RECTANGLE: {
                return new RectangleNode(eObject, text, this.getFont(), textRegion);
            }
            case ROUNDED: {
                return new RoundedNode(eObject, text, this.getFont(), textRegion);
            }
            case ERROR: {
                return new ErrorNode(eObject, text, this.getFont(), textRegion);
            }
            case LABEL: {
                return new LabelNode(eObject, text, this.getFont(), textRegion);
            }
        }
        throw new IllegalArgumentException("Unknown node type " + String.valueOf((Object)type));
    }

    protected Font getFont() {
        if (this.font == null) {
            if (Display.getCurrent() != null) {
                this.font = Display.getCurrent().getSystemFont();
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PrimitiveFigureFactory.this.font = Display.getCurrent().getSystemFont();
                    }
                });
            }
        }
        return this.font;
    }
}

