/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DTDAttlistDecl;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.DTDElementDecl;
import org.eclipse.lemminx.extensions.contentmodel.model.FilesChangedTracker;
import org.eclipse.lemminx.utils.URIUtils;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DTDUtils {
    public static void searchDTDTargetElementDecl(DTDDeclParameter originNameNode, boolean matchName, Consumer<DTDDeclParameter> collector) {
        DOMDocumentType docType = originNameNode.getOwnerDocType();
        if (docType.hasChildNodes()) {
            NodeList children = docType.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                DTDElementDecl targetElementDecl;
                Node node = children.item(i);
                if (node.getNodeType() != 101 || !DTDUtils.isValid(targetElementDecl = (DTDElementDecl)node)) continue;
                DTDDeclParameter targetElementName = targetElementDecl.getNameParameter();
                if (matchName && (!matchName || !originNameNode.getParameter().equals(targetElementName.getParameter()))) continue;
                collector.accept(targetElementName);
            }
        }
    }

    public static void searchDTDOriginElementDecls(DTDDeclNode targetNode, BiConsumer<DTDDeclParameter, DTDDeclParameter> collector, CancelChecker cancelChecker) {
        List<DTDDeclNode> targetNodes = DTDUtils.getTargetNodes(targetNode);
        if (targetNodes.isEmpty()) {
            return;
        }
        DOMDocumentType docType = targetNode.getOwnerDocType();
        if (docType.hasChildNodes()) {
            NodeList children = docType.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (cancelChecker != null) {
                    cancelChecker.checkCanceled();
                }
                Node origin = children.item(i);
                for (DTDDeclNode target : targetNodes) {
                    if (!target.isDTDElementDecl()) continue;
                    DTDElementDecl targetElement = (DTDElementDecl)target;
                    switch (origin.getNodeType()) {
                        case 101: {
                            DTDElementDecl originElement = (DTDElementDecl)origin;
                            originElement.collectParameters(targetElement.getNameParameter(), collector);
                            break;
                        }
                        case 102: {
                            String name = targetElement.getName();
                            DTDAttlistDecl originAttribute = (DTDAttlistDecl)origin;
                            if (!name.equals(originAttribute.getElementName())) break;
                            collector.accept(originAttribute.getNameParameter(), targetElement.getNameParameter());
                        }
                    }
                }
            }
        }
    }

    private static List<DTDDeclNode> getTargetNodes(DTDDeclNode referencedNode) {
        ArrayList<DTDDeclNode> referencedNodes = new ArrayList<DTDDeclNode>();
        switch (referencedNode.getNodeType()) {
            case 101: {
                DTDUtils.addTargetNode(referencedNode, referencedNodes);
                break;
            }
            case 10: {
                DOMDocumentType docType = (DOMDocumentType)referencedNode;
                if (!docType.hasChildNodes()) break;
                NodeList children = docType.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 101) continue;
                    DTDUtils.addTargetNode((DTDElementDecl)node, referencedNodes);
                }
                break;
            }
        }
        return referencedNodes;
    }

    private static void addTargetNode(DTDDeclNode referencedNode, List<DTDDeclNode> referencedNodes) {
        DTDElementDecl elementDecl;
        if (referencedNode.isDTDElementDecl() && DTDUtils.isValid(elementDecl = (DTDElementDecl)referencedNode)) {
            referencedNodes.add(elementDecl);
        }
    }

    private static boolean isValid(DTDElementDecl elementDecl) {
        if (elementDecl == null) {
            return false;
        }
        return elementDecl.getNameParameter() != null;
    }

    public static FilesChangedTracker createFilesChangedTracker(DTDGrammar grammar) {
        FilesChangedTracker tracker = new FilesChangedTracker();
        HashSet<DTDGrammar> trackedGrammars = new HashSet<DTDGrammar>();
        DTDUtils.updateTracker(grammar, trackedGrammars, tracker);
        return tracker;
    }

    private static void updateTracker(DTDGrammar grammar, Set<DTDGrammar> trackedGrammars, FilesChangedTracker tracker) {
        if (grammar == null || trackedGrammars.contains(grammar)) {
            return;
        }
        trackedGrammars.add(grammar);
        String dtdURI = DTDUtils.getDTDURI(grammar);
        if (dtdURI != null && URIUtils.isFileResource(dtdURI)) {
            tracker.addFileURI(dtdURI);
        }
    }

    private static String getDTDURI(DTDGrammar grammar) {
        return grammar.getGrammarDescription().getExpandedSystemId();
    }
}

