/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.ui.actions.FindAction;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public class FindReferencesAction
extends FindAction {
    public FindReferencesAction(IWorkbenchSite site) {
        super(site);
    }

    public FindReferencesAction(JavaEditor editor) {
        super(editor);
    }

    @Override
    Class[] getValidTypes() {
        return new Class[]{IJavaScriptUnit.class, IType.class, IFunction.class, IField.class, IImportDeclaration.class, IPackageFragment.class, ILocalVariable.class};
    }

    @Override
    void init() {
        this.setText(SearchMessages.Search_FindReferencesAction_label);
        this.setToolTipText(SearchMessages.Search_FindReferencesAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_REF);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_references_in_workspace_action");
    }

    @Override
    int getLimitTo() {
        return 2;
    }

    @Override
    QuerySpecification createQuery(IJavaScriptElement element) throws JavaScriptModelException, InterruptedException {
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        boolean isInsideJRE = factory.isInsideJRE(element);
        IJavaScriptSearchScope scope = factory.createWorkspaceScope(isInsideJRE);
        String description = factory.getWorkspaceScopeDescription(isInsideJRE);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }

    @Override
    public void run(IJavaScriptElement element) {
        SearchUtil.warnIfBinaryConstant(element, this.getShell());
        super.run(element);
    }
}

