/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.elementedit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.PageDesignerTraceOptions;
import org.eclipse.jst.pagedesigner.elementedit.IElementEditFactory;

public class ElementEditFacRegistryReader {
    private static List<IElementEditFactory> _handlers = null;

    public static synchronized List<IElementEditFactory> getAllHandlers() {
        if (_handlers == null) {
            _handlers = ElementEditFacRegistryReader.readAllHandlers();
        }
        return Collections.unmodifiableList(_handlers);
    }

    private static List<IElementEditFactory> readAllHandlers() {
        ArrayList<IElementEditFactory> result = new ArrayList<IElementEditFactory>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PDPlugin.getPluginId(), "pageDesignerExtension");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] elementEditElement = ext.getConfigurationElements();
            int j = 0;
            while (j < elementEditElement.length) {
                IConfigurationElement element = elementEditElement[j];
                if (element.getName().equals("elementEditFactory")) {
                    elementEditElement[j].getAttribute("class");
                    try {
                        Object obj = elementEditElement[j].createExecutableExtension("class");
                        if (obj instanceof IElementEditFactory) {
                            if (element.getContributor().getName().startsWith("org.eclipse.jst")) {
                                if (PageDesignerTraceOptions.TRACE_ELEMENTEDITLOAD) {
                                    PageDesignerTraceOptions.log("ElementEditFacRegistryReader: Appending to list:" + obj.getClass().getName());
                                }
                                result.add((IElementEditFactory)obj);
                            } else {
                                if (PageDesignerTraceOptions.TRACE_ELEMENTEDITLOAD) {
                                    PageDesignerTraceOptions.log("ElementEditFacRegistryReader: Prepending to list:" + obj.getClass().getName());
                                }
                                result.add(0, (IElementEditFactory)obj);
                            }
                        }
                    }
                    catch (CoreException e) {
                        PDPlugin.log("Problem loading element edit extension for " + element.toString(), e);
                    }
                }
                ++j;
            }
            ++i;
        }
        if (PageDesignerTraceOptions.TRACE_ELEMENTEDITLOAD) {
            PageDesignerTraceOptions.log("\nFinal elementEditFactory list in order:");
            for (IElementEditFactory factory : result) {
                PageDesignerTraceOptions.log(factory.getClass().getName());
            }
            PageDesignerTraceOptions.log("\n");
        }
        return result;
    }
}

