/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Map;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.launch.BundleModule;
import org.eclipse.sisu.launch.BundlePlan;
import org.eclipse.sisu.plexus.PlexusSpaceModule;
import org.eclipse.sisu.space.BeanScanning;
import org.eclipse.sisu.space.ClassSpace;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class PlexusBundlePlan
implements BundlePlan {
    private static final String SUPPORT_BUNDLE_NAME = FrameworkUtil.getBundle(PlexusSpaceModule.class).getSymbolicName();
    protected final MutableBeanLocator locator;

    public PlexusBundlePlan(MutableBeanLocator locator) {
        this.locator = locator;
    }

    public BindingPublisher prepare(Bundle bundle) {
        if (!SUPPORT_BUNDLE_NAME.equals(bundle.getSymbolicName()) && (PlexusBundlePlan.hasPlexusAnnotations(bundle) || PlexusBundlePlan.hasPlexusXml(bundle))) {
            return new InjectorBindings(Guice.createInjector((Module[])new Module[]{new BundleModule(bundle, this.locator){

                protected Module spaceModule() {
                    return new PlexusSpaceModule((ClassSpace)this.space, BeanScanning.select((Map)this.getProperties()));
                }
            }}));
        }
        return null;
    }

    protected static boolean hasPlexusAnnotations(Bundle bundle) {
        String imports = (String)bundle.getHeaders().get("Import-Package");
        return null != imports && imports.contains("org.codehaus.plexus.component.annotations");
    }

    protected static boolean hasPlexusXml(Bundle bundle) {
        return null != bundle.findEntries("META-INF/plexus", "components.xml", false);
    }
}

