/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IIndentationStrategy;
import org.eclipse.php.internal.core.format.IndentationObject;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class CaseDefaultIndentationStrategy
implements IIndentationStrategy {
    private IndentationObject indentationObject;

    public CaseDefaultIndentationStrategy() {
    }

    public CaseDefaultIndentationStrategy(IndentationObject indentationObject) {
        this.indentationObject = indentationObject;
    }

    @Override
    public void placeMatchingBlanks(IStructuredDocument document, StringBuilder result, int lineNumber, int offset) throws BadLocationException {
        IRegion indentationBase = null;
        boolean found = false;
        boolean addIndentation = false;
        int curlyCount = 0;
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        if (sdRegion == null) {
            return;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion == null) {
            return;
        }
        int regionStart = sdRegion.getStartOffset(tRegion);
        if (tRegion instanceof ITextRegionContainer) {
            ITextRegionContainer container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
            regionStart += tRegion.getStart();
        }
        if (tRegion instanceof IPHPScriptRegion) {
            IPHPScriptRegion scriptRegion = (IPHPScriptRegion)tRegion;
            tRegion = scriptRegion.getPHPToken(offset - regionStart - 1);
            while (true) {
                String token;
                if ((token = tRegion.getType()) == "PHP_CURLY_OPEN") {
                    if (--curlyCount < 0) {
                        found = true;
                        addIndentation = true;
                    }
                } else if (token == "PHP_CURLY_CLOSE") {
                    ++curlyCount;
                } else if ((token == "PHP_CASE" || token == "PHP_DEFAULT") && curlyCount == 0) {
                    found = true;
                }
                if (found) {
                    indentationBase = document.getLineInformationOfOffset(tRegion.getStart() + regionStart);
                    break;
                }
                if (tRegion.getStart() <= 0) break;
                tRegion = scriptRegion.getPHPToken(tRegion.getStart() - 1);
            }
        }
        if (indentationBase != null) {
            String blanks = FormatterUtils.getLineBlanks((IDocument)document, indentationBase);
            result.append(blanks);
            if (addIndentation) {
                if (this.indentationObject == null) {
                    this.indentationObject = new IndentationObject(document);
                }
                int i = 0;
                while (i < this.indentationObject.getIndentationSize()) {
                    result.append(this.indentationObject.getIndentationChar());
                    ++i;
                }
            }
        }
    }
}

