/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.internal.handler;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.terminal.view.core.ITerminalContextPropertiesProvider;
import org.eclipse.terminal.view.core.TerminalContextPropertiesProviderFactory;
import org.eclipse.terminal.view.ui.internal.UIPlugin;
import org.eclipse.terminal.view.ui.internal.dialogs.LaunchTerminalSettingsDialog;
import org.eclipse.terminal.view.ui.launcher.ILauncherDelegate;
import org.eclipse.ui.handlers.HandlerUtil;

public class LaunchTerminalCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        long start = System.currentTimeMillis();
        if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
            DateFormat format = DateFormat.getDateTimeInstance(3, 3);
            String date = format.format(new Date(start));
            UIPlugin.getTraceHandler().trace("Started at " + date + " (" + start + ")", "trace/launchTerminalCommandHandler", (Object)this);
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (commandId.equals("org.eclipse.terminal.view.ui.command.launchConsole")) {
            LaunchTerminalSettingsDialog dialog = new LaunchTerminalSettingsDialog(shell, start);
            if (dialog.open() == 0) {
                Optional<ILauncherDelegate> delegate = this.findDelegate(dialog);
                if (delegate.isEmpty()) {
                    return null;
                }
                return this.createConnector(delegate.get(), dialog.getSettings());
            }
            return null;
        }
        if (commandId.equals("org.eclipse.terminal.view.ui.command.launchToolbar")) {
            Optional<ILauncherDelegate> delegate;
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("(a) Attempt to open launch terminal settings dialog after " + (System.currentTimeMillis() - start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            LaunchTerminalSettingsDialog dialog = new LaunchTerminalSettingsDialog(shell, start);
            if (this.isValidSelection(selection)) {
                dialog.setSelection(selection);
            }
            if (dialog.open() == 0 && (delegate = this.findDelegate(dialog)).isPresent()) {
                this.executeDelegate(dialog.getSettings(), delegate.get());
            }
        } else {
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("Getting applicable launcher delegates after " + (System.currentTimeMillis() - start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            List<ILauncherDelegate> delegates = UIPlugin.getLaunchDelegateManager().getApplicableLauncherDelegates(selection).toList();
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("Got applicable launcher delegates after " + (System.currentTimeMillis() - start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            if (delegates.size() > 1 || delegates.size() == 1 && delegates.get(0).needsUserConfiguration()) {
                Optional<ILauncherDelegate> delegate;
                if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                    UIPlugin.getTraceHandler().trace("(b) Attempt to open launch terminal settings dialog after " + (System.currentTimeMillis() - start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
                }
                LaunchTerminalSettingsDialog dialog = new LaunchTerminalSettingsDialog(shell, start);
                if (this.isValidSelection(selection)) {
                    dialog.setSelection(selection);
                }
                if (dialog.open() == 0 && (delegate = this.findDelegate(dialog)).isPresent()) {
                    this.executeDelegate(dialog.getSettings(), delegate.get());
                }
            } else if (delegates.size() == 1) {
                ILauncherDelegate delegate = delegates.get(0);
                this.executeDelegate(selection, delegate);
            }
        }
        return null;
    }

    private Optional<ILauncherDelegate> findDelegate(LaunchTerminalSettingsDialog dialog) {
        return Optional.ofNullable(dialog.getSettings()).map(map -> map.get("delegateId")).filter(String.class::isInstance).map(String.class::cast).flatMap(id -> UIPlugin.getLaunchDelegateManager().findLauncherDelegate((String)id, false));
    }

    private ITerminalConnector createConnector(ILauncherDelegate delegate, Map<String, Object> settings) throws ExecutionException {
        try {
            return delegate.createTerminalConnector(settings);
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getStatus().getMessage(), (Throwable)e);
        }
    }

    private boolean isValidSelection(ISelection selection) {
        Map props;
        Object element;
        ITerminalContextPropertiesProvider provider;
        return selection instanceof IStructuredSelection && !selection.isEmpty() && (provider = TerminalContextPropertiesProviderFactory.getProvider((Object)(element = ((IStructuredSelection)selection).getFirstElement()))) != null && (props = provider.getTargetAddress(element)) != null && props.containsKey("address");
    }

    private void executeDelegate(ISelection selection, ILauncherDelegate delegate) throws ExecutionException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("delegateId", delegate.getId());
        properties.put("selection", selection);
        this.executeDelegate(properties, delegate);
    }

    private void executeDelegate(Map<String, Object> properties, ILauncherDelegate delegate) throws ExecutionException {
        delegate.execute(properties).whenComplete((r, e) -> {
            if (e != null) {
                ILog.get().error("Error occurred while running delegate to open console", e);
            }
        });
    }
}

