/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace.overlay;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;

class FindReplaceOverlayAction {
    private final Runnable operation;
    private final List<KeyStroke> shortcuts = new ArrayList<KeyStroke>();

    FindReplaceOverlayAction(Runnable operation) {
        this.operation = operation;
    }

    void addShortcuts(List<KeyStroke> shortcutsToAdd) {
        this.shortcuts.addAll(shortcutsToAdd);
    }

    void execute() {
        this.operation.run();
    }

    boolean executeIfMatching(KeyStroke keystroke) {
        if (this.shortcuts.stream().anyMatch(arg_0 -> ((KeyStroke)keystroke).equals(arg_0))) {
            this.execute();
            return true;
        }
        return false;
    }

    String addShortcutHintToTooltipText(String originalTooltipText) {
        if (this.shortcuts.isEmpty()) {
            return originalTooltipText;
        }
        return originalTooltipText + " (" + this.shortcuts.get(0).format() + ")";
    }
}

