/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.search.BasicSearchMatchElement;

public class BasicSearchQuery
implements ISearchQuery {
    private IFile fFile = null;
    private AbstractTextSearchResult fResult = null;
    private IProgressMonitor fProgressMonitor = null;

    public BasicSearchQuery(IFile file) {
        this.fFile = file;
    }

    public IStatus run(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
        return this.doQuery();
    }

    public IFile getFile() {
        return this.fFile;
    }

    public String getLabel() {
        return "";
    }

    public ISearchResult getSearchResult() {
        return this.fResult;
    }

    public void addMatch(IDocument document, int matchStart, int matchEnd) {
        try {
            int lineNumber = document.getLineOfOffset(matchStart);
            int lineStart = document.getLineOffset(lineNumber);
            int lineLength = document.getLineLength(lineNumber);
            String elementMessage = document.get().substring(lineStart, lineStart + lineLength);
            BasicSearchMatchElement element = new BasicSearchMatchElement(this.fFile, lineNumber, lineStart, elementMessage);
            this.fResult.addMatch(new Match((Object)element, 2, matchStart, matchEnd - matchStart));
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    protected IStatus doQuery() {
        return this.doQuery(this.fProgressMonitor);
    }

    protected IStatus doQuery(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected int getMatchCount() {
        return this.fResult.getMatchCount();
    }

    protected String getSearchText() {
        return "";
    }

    protected void setResult(AbstractTextSearchResult result) {
        this.fResult = result;
    }
}

