/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.sync;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

public class SynchronizationSession
implements ISynchronizationSession {
    private Set<ITask> changedTasks;
    private Object data;
    private boolean fullSynchronization;
    private boolean performQueries;
    private Set<ITask> staleTasks;
    private IStatus status;
    private TaskDataManager taskDataManager;
    private TaskRepository taskRepository;
    private Set<ITask> tasks;
    private boolean user;

    public SynchronizationSession() {
    }

    public SynchronizationSession(TaskDataManager taskDataManager) {
        this.taskDataManager = taskDataManager;
    }

    @Override
    public Set<ITask> getChangedTasks() {
        return this.changedTasks;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public Set<ITask> getStaleTasks() {
        if (this.staleTasks == null) {
            return Collections.emptySet();
        }
        return this.staleTasks;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public TaskDataManager getTaskDataManager() {
        return this.taskDataManager;
    }

    @Override
    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    @Override
    public Set<ITask> getTasks() {
        return this.tasks;
    }

    @Override
    public boolean isFullSynchronization() {
        return this.fullSynchronization;
    }

    @Override
    public boolean isUser() {
        return this.user;
    }

    @Override
    public void markStale(ITask task) {
        if (this.staleTasks == null) {
            this.staleTasks = new HashSet<ITask>();
        }
        this.staleTasks.add(task);
    }

    @Override
    public boolean needsPerformQueries() {
        return this.performQueries;
    }

    @Override
    public void putTaskData(ITask task, TaskData taskData) throws CoreException {
        if (this.taskDataManager != null) {
            this.taskDataManager.putUpdatedTaskData(task, taskData, false);
        }
    }

    public void setChangedTasks(Set<ITask> changedTasks) {
        this.changedTasks = changedTasks;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    public void setFullSynchronization(boolean fullSynchronization) {
        this.fullSynchronization = fullSynchronization;
    }

    @Override
    public void setNeedsPerformQueries(boolean performQueries) {
        this.performQueries = performQueries;
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    public void setTaskRepository(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    public void setTasks(Set<ITask> tasks) {
        this.tasks = tasks;
    }

    public void setUser(boolean user) {
        this.user = user;
    }
}

