/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

class MethodSegmentResolver {
    private static final Pattern METHOD_PATTERN = Pattern.compile("(?:(?<declaringClass>.+)#)?(?<method>.+)\\((?<parameters>.*)\\)");

    MethodSegmentResolver() {
    }

    String formatMethodSpecPart(Method method, Class<?> testClass) {
        String parameterTypes = ClassUtils.nullSafeToString((Class[])method.getParameterTypes());
        if (ReflectionUtils.isPackagePrivate((Member)method) && !ReflectionUtils.isDeclaredInSamePackage(method.getDeclaringClass(), testClass)) {
            return String.format("%s#%s(%s)", method.getDeclaringClass().getName(), method.getName(), parameterTypes);
        }
        return String.format("%s(%s)", method.getName(), parameterTypes);
    }

    Optional<Method> findMethod(String methodSpecPart, Class<?> testClass) {
        Matcher matcher = METHOD_PATTERN.matcher(methodSpecPart);
        Preconditions.condition((boolean)matcher.matches(), () -> String.format("Method [%s] does not match pattern [%s]", methodSpecPart, METHOD_PATTERN));
        Class targetClass = testClass;
        String declaringClass = matcher.group("declaringClass");
        if (declaringClass != null) {
            targetClass = (Class)ReflectionUtils.tryToLoadClass((String)declaringClass).getOrThrow(cause -> new PreconditionViolationException("Could not load declaring class with name: " + declaringClass, (Throwable)cause));
        }
        String methodName = matcher.group("method");
        String parameterTypeNames = matcher.group("parameters");
        return ReflectionSupport.findMethod((Class)targetClass, (String)methodName, (String)parameterTypeNames);
    }
}

