/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public record TerminalViewId(String primary, Optional<String> secondary) {
    public TerminalViewId() {
        this("org.eclipse.terminal.view.ui.TerminalsView");
    }

    public TerminalViewId(String primary) {
        this(primary, Optional.empty());
    }

    public TerminalViewId(String primary, String secondary) {
        this(primary, Optional.ofNullable(secondary));
    }

    public TerminalViewId next() {
        return new TerminalViewId(this.primary, TerminalViewId.nextSecondaryId(this.primary));
    }

    private static String nextSecondaryId(String primary) {
        HashMap<String, IViewReference> terminalViews = new HashMap<String, IViewReference>();
        int maxNumber = 0;
        for (IViewReference ref : TerminalViewId.viewReferences()) {
            if (!ref.getId().equals(primary)) continue;
            if (ref.getSecondaryId() != null) {
                terminalViews.put(ref.getSecondaryId(), ref);
                int scondaryIdInt = Integer.parseInt(ref.getSecondaryId());
                if (scondaryIdInt <= maxNumber) continue;
                maxNumber = scondaryIdInt;
                continue;
            }
            terminalViews.put(Integer.toString(0), ref);
        }
        if (terminalViews.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < maxNumber) {
            String secondaryIdStr = Integer.toString(i);
            if (!terminalViews.keySet().contains(secondaryIdStr)) {
                if (i == 0) {
                    return null;
                }
                return Integer.toString(i);
            }
            ++i;
        }
        return Integer.toString(i + 1);
    }

    private static List<IViewReference> viewReferences() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return Collections.emptyList();
        }
        return Optional.of(PlatformUI.getWorkbench()).map(IWorkbench::getActiveWorkbenchWindow).map(IWorkbenchWindow::getActivePage).map(IWorkbenchPage::getViewReferences).map(iViewReferenceArray -> Arrays.asList(iViewReferenceArray)).orElseGet(Collections::emptyList);
    }
}

