/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.nls.IEditableTranslationStore;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationEntry;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.TextProviderService;
import org.eclipse.scout.sdk.core.util.Ensure;

public class FilteredTranslationStore
implements IEditableTranslationStore {
    private final ITranslationStore m_store;
    private final Set<String> m_keysFilter;

    public FilteredTranslationStore(ITranslationStore store, Collection<String> availableKeysFilter) {
        this.m_store = (ITranslationStore)Ensure.notNull((Object)store);
        this.m_keysFilter = new HashSet<String>((Collection)Ensure.notNull(availableKeysFilter));
    }

    private static IEditableTranslationStore toEditableStore(ITranslationStore store) {
        return (IEditableTranslationStore)store;
    }

    @Override
    public void flush(IEnvironment env, IProgress progress) {
        FilteredTranslationStore.toEditableStore(this.m_store).flush(env, progress);
    }

    @Override
    public ITranslationEntry removeTranslation(String key) {
        return FilteredTranslationStore.toEditableStore(this.m_store).removeTranslation(key);
    }

    @Override
    public void addNewLanguage(Language language) {
        FilteredTranslationStore.toEditableStore(this.m_store).addNewLanguage(language);
    }

    @Override
    public boolean isDirty() {
        return FilteredTranslationStore.toEditableStore(this.m_store).isDirty();
    }

    @Override
    public ITranslationEntry changeKey(String oldKey, String newKey) {
        return FilteredTranslationStore.toEditableStore(this.m_store).changeKey(oldKey, newKey);
    }

    @Override
    public ITranslationEntry setTranslation(ITranslation template) {
        return FilteredTranslationStore.toEditableStore(this.m_store).setTranslation(template);
    }

    @Override
    public boolean isEditable() {
        return this.m_store.isEditable();
    }

    @Override
    public Stream<String> keys() {
        return this.m_store.keys().filter(this.keysFilter()::contains);
    }

    @Override
    public long size() {
        return this.keys().count();
    }

    @Override
    public boolean containsKey(String key) {
        return this.keysFilter().contains(key) && this.m_store.containsKey(key);
    }

    @Override
    public boolean containsLanguage(Language language) {
        return this.languages().anyMatch(Predicate.isEqual(language));
    }

    @Override
    public Stream<? extends ITranslationEntry> entries() {
        return this.m_store.entries().filter(e -> this.keysFilter().contains(e.key()));
    }

    @Override
    public Stream<Language> languages() {
        return this.entries().flatMap(ITranslation::languages).distinct();
    }

    @Override
    public Optional<ITranslationEntry> get(String key) {
        return this.m_store.get(key).filter(e -> this.keysFilter().contains(e.key()));
    }

    @Override
    public Optional<Map<String, String>> get(Language language) {
        return this.m_store.get(language).map(this::getFilteredCopy);
    }

    protected Map<String, String> getFilteredCopy(Map<String, String> original) {
        return original.entrySet().stream().filter(entry -> this.keysFilter().contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected Set<String> keysFilter() {
        return this.m_keysFilter;
    }

    protected ITranslationStore nestedStore() {
        return this.m_store;
    }

    @Override
    public Optional<String> get(String key, Language language) {
        if (!this.keysFilter().contains(key)) {
            return Optional.empty();
        }
        return this.m_store.get(key, language);
    }

    @Override
    public TextProviderService service() {
        return this.m_store.service();
    }

    @Override
    public void reload(IProgress progress) {
        this.m_store.reload(progress);
    }

    public int hashCode() {
        return Objects.hash(this.service(), this.keysFilter());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FilteredTranslationStore other = (FilteredTranslationStore)obj;
        return this.service().equals(other.service()) && this.keysFilter().equals(other.keysFilter());
    }

    public String toString() {
        return FilteredTranslationStore.class.getSimpleName() + " [" + this.service().type().name() + "]";
    }
}

