/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.preferences;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.context.PersistentActionDialogsContext;
import org.eclipse.wst.command.internal.env.preferences.ActionDialogPreferenceType;
import org.eclipse.wst.command.internal.env.ui.EnvironmentUIMessages;

public class ActionDialogsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener,
IExecutableExtension {
    private String INFOPOP_PPAD_PAGE = "org.eclipse.wst.command.env.ui.PPAD0001";
    private Button showAll;
    private String INFOPOP_PPAD_BUTTON_SHOW_ALL = "org.eclipse.wst.command.env.ui.PPAD0002";
    private Button hideAll;
    private String INFOPOP_PPAD_BUTTON_HIDE_ALL = "org.eclipse.wst.command.env.ui.PPAD0003";
    private Hashtable checkBoxes_;
    private String categoryId_;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.categoryId_ = config.getAttribute("id");
    }

    protected Control createContents(Composite superparent) {
        this.checkBoxes_ = new Hashtable();
        this.addOptionalDialogsCheckBoxes(superparent);
        new Label(superparent, 256);
        Composite parent = new Composite(superparent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        parent.setToolTipText(EnvironmentUIMessages.TOOLTIP_PPAD_PAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.INFOPOP_PPAD_PAGE);
        this.showAll = new Button(parent, 0);
        this.showAll.setText(EnvironmentUIMessages.BUTTON_SHOW_ALL_DIALOGS);
        this.showAll.addListener(13, (Listener)this);
        this.showAll.setToolTipText(EnvironmentUIMessages.TOOLTIP_PPAD_BUTTON_SHOW_ALL);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.showAll, this.INFOPOP_PPAD_BUTTON_SHOW_ALL);
        this.hideAll = new Button(parent, 0);
        this.hideAll.setText(EnvironmentUIMessages.BUTTON_HIDE_ALL_DIALOGS);
        this.hideAll.addListener(13, (Listener)this);
        this.hideAll.setToolTipText(EnvironmentUIMessages.TOOLTIP_PPAD_BUTTON_HIDE_ALL);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.hideAll, this.INFOPOP_PPAD_BUTTON_HIDE_ALL);
        this.initializeValues();
        Dialog.applyDialogFont((Control)superparent);
        return parent;
    }

    public void handleEvent(Event event) {
        if (this.showAll == event.widget) {
            this.handleShowAllEvent();
        } else if (this.hideAll == event.widget) {
            this.handleHideAllEvent();
        }
    }

    private void handleShowAllEvent() {
        Enumeration e = this.checkBoxes_.elements();
        while (e.hasMoreElements()) {
            Button dialog = (Button)e.nextElement();
            dialog.setSelection(false);
        }
    }

    private void handleHideAllEvent() {
        Enumeration e = this.checkBoxes_.elements();
        while (e.hasMoreElements()) {
            Button dialog = (Button)e.nextElement();
            dialog.setSelection(true);
        }
    }

    private void addOptionalDialogsCheckBoxes(Composite parent) {
        PersistentActionDialogsContext context = PersistentActionDialogsContext.getInstance();
        ActionDialogPreferenceType[] dialogs = context.getDialogs();
        int i = 0;
        while (i < dialogs.length) {
            ActionDialogPreferenceType dialog = dialogs[i];
            String category = dialog.getCategory();
            if (dialog.getShowCheckbox() && category != null && category.equals(this.categoryId_)) {
                Button checkBox = this.createCheckBox(parent, dialog.getName());
                checkBox.setToolTipText(dialog.getTooltip());
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)checkBox, dialog.getInfopop());
                this.checkBoxes_.put(dialog.getId(), checkBox);
            }
            ++i;
        }
    }

    private Button createCheckBox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        return button;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        PersistentActionDialogsContext context = PersistentActionDialogsContext.getInstance();
        Enumeration e = this.checkBoxes_.keys();
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            Button dialog = (Button)this.checkBoxes_.get(id);
            dialog.setSelection(context.getDefaultBoolean(id));
        }
    }

    private void initializeValues() {
        PersistentActionDialogsContext context = PersistentActionDialogsContext.getInstance();
        Enumeration e = this.checkBoxes_.keys();
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            Button button = (Button)this.checkBoxes_.get(id);
            button.setSelection(context.isActionDialogEnabled(id));
        }
    }

    private void storeValues() {
        PersistentActionDialogsContext context = PersistentActionDialogsContext.getInstance();
        Enumeration e = this.checkBoxes_.keys();
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            context.setActionDialogEnabled(id, ((Button)this.checkBoxes_.get(id)).getSelection());
        }
    }
}

