/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.util.ITier;
import org.eclipse.scout.sdk.core.s.util.TierTree;

public enum ScoutTier implements ITier<IScoutApi>
{
    Client("client", api -> api.IClientSession().fqn()),
    Shared("shared", api -> api.ISession().fqn()),
    Server("server", api -> api.IServerSession().fqn()),
    HtmlUi("ui.html", api -> api.UiServlet().fqn());

    private final String m_tierName;
    private final Function<IScoutApi, String> m_lookupFqnFunction;

    public static void initTierTree() {
        TierTree.addDependency(HtmlUi, Client);
        TierTree.addDependency(Client, Shared);
        TierTree.addDependency(Server, Shared);
    }

    private ScoutTier(String tierName, Function<IScoutApi, String> lookupFqnFunction) {
        this.m_tierName = tierName;
        this.m_lookupFqnFunction = lookupFqnFunction;
    }

    @Override
    public String tierName() {
        return this.m_tierName;
    }

    @Override
    public String getLookupFqn(IScoutApi api) {
        return Optional.ofNullable(api).map(this.m_lookupFqnFunction).orElse(null);
    }

    @Override
    public Class<IScoutApi> getApiClass() {
        return IScoutApi.class;
    }
}

