/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.IJavaSourceBuilder;
import org.eclipse.scout.sdk.core.java.builder.JavaBuilderContextFunction;
import org.eclipse.scout.sdk.core.java.builder.JavaSourceBuilder;
import org.eclipse.scout.sdk.core.java.builder.comment.IJavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.java.builder.comment.JavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.java.generator.IJavaElementGenerator;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public abstract class AbstractJavaElementGenerator<TYPE extends IJavaElementGenerator<TYPE>>
implements IJavaElementGenerator<TYPE> {
    private JavaBuilderContextFunction<String> m_elementName;
    private ISourceGenerator<IJavaElementCommentBuilder<?>> m_comment;
    private final List<BiConsumer<TYPE, IJavaBuilderContext>> m_preProcessors = new ArrayList<BiConsumer<TYPE, IJavaBuilderContext>>();

    protected AbstractJavaElementGenerator() {
    }

    protected AbstractJavaElementGenerator(IJavaElement element) {
        this();
        this.withElementName(((IJavaElement)Ensure.notNull((Object)element)).elementName());
    }

    protected TYPE thisInstance() {
        return (TYPE)this;
    }

    @Override
    public Optional<String> elementName() {
        return this.elementNameFunc().flatMap(JavaBuilderContextFunction::apply);
    }

    @Override
    public Optional<String> elementName(IJavaBuilderContext context) {
        return this.elementNameFunc().map(f -> (String)f.apply(context));
    }

    @Override
    public Optional<JavaBuilderContextFunction<String>> elementNameFunc() {
        return Optional.ofNullable(this.m_elementName);
    }

    @Override
    public TYPE withElementName(String newName) {
        this.m_elementName = Strings.isEmpty((CharSequence)newName) ? null : JavaBuilderContextFunction.create(newName);
        return this.thisInstance();
    }

    @Override
    public <A extends IApiSpecification> TYPE withElementNameFrom(Class<A> apiDefinition, Function<A, String> nameSupplier) {
        this.m_elementName = new ApiFunction<A, String>(apiDefinition, nameSupplier);
        return this.thisInstance();
    }

    @Override
    public TYPE withElementNameFunc(Function<IJavaBuilderContext, String> nameSupplier) {
        this.m_elementName = JavaBuilderContextFunction.orNull(nameSupplier);
        return this.thisInstance();
    }

    protected void build(IJavaSourceBuilder<?> builder) {
        IJavaBuilderContext context = builder.context();
        this.preProcessors().forEach(c -> c.accept(this, context));
        this.createComment(builder);
    }

    @Override
    public Stream<BiConsumer<TYPE, IJavaBuilderContext>> preProcessors() {
        return this.m_preProcessors.stream();
    }

    @Override
    public TYPE withPreProcessor(BiConsumer<TYPE, IJavaBuilderContext> processor) {
        if (processor != null) {
            this.m_preProcessors.add(processor);
        }
        return this.thisInstance();
    }

    protected void createComment(ISourceBuilder<?> builder) {
        this.comment().map(b -> b.generalize(this::createCommentBuilder)).ifPresent(arg_0 -> builder.append(arg_0));
    }

    protected IJavaElementCommentBuilder<?> createCommentBuilder(ISourceBuilder<?> builder) {
        return JavaElementCommentBuilder.create(builder);
    }

    public static IJavaSourceBuilder<?> ensureJavaSourceBuilder(ISourceBuilder<?> inner) {
        if (inner instanceof IJavaSourceBuilder) {
            return (IJavaSourceBuilder)inner;
        }
        return JavaSourceBuilder.create(inner);
    }

    public static String ensureValidJavaName(String parameterName) {
        if (JavaTypes.isReservedJavaKeyword(parameterName)) {
            return parameterName + "_";
        }
        return parameterName;
    }

    public final void generate(ISourceBuilder<?> builder) {
        this.build(AbstractJavaElementGenerator.ensureJavaSourceBuilder(builder));
    }

    @Override
    public TYPE withComment(ISourceGenerator<IJavaElementCommentBuilder<?>> commentBuilder) {
        this.m_comment = commentBuilder;
        return this.thisInstance();
    }

    @Override
    public Optional<ISourceGenerator<IJavaElementCommentBuilder<?>>> comment() {
        return Optional.ofNullable(this.m_comment);
    }
}

