/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.util;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.junit.model.JUnitModel;
import org.eclipse.jdt.internal.junit.model.TestRunHandler;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.ITestCase;
import org.eclipse.mylyn.builds.core.ITestSuite;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeEvent;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeListener;
import org.eclipse.mylyn.builds.internal.core.operations.RefreshOperation;
import org.eclipse.mylyn.builds.internal.core.util.JUnitResultGenerator;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiPlugin;
import org.eclipse.mylyn.internal.builds.ui.util.TestResultSession;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TestResultManager {
    public static boolean isJUnitAvailable() {
        return Platform.getBundle((String)"org.eclipse.jdt.junit") != null;
    }

    static boolean jUnitSupportIgnoredTests() {
        return Platform.getBundle((String)"org.eclipse.jdt.junit.core") != null;
    }

    public static void openInEditor(ITestCase testCase) {
        if (!TestResultManager.isJUnitAvailable()) {
            return;
        }
        Runner.openInEditor(testCase.getClassName(), testCase.getLabel());
    }

    public static void openInEditor(ITestSuite suite) {
        if (!TestResultManager.isJUnitAvailable()) {
            return;
        }
        Runner.openInEditor(suite.getLabel(), null);
    }

    public static void showInJUnitView(IBuild build) {
        Assert.isNotNull((Object)build);
        if (!TestResultManager.isJUnitAvailable()) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", "JUnit is not installed."), 6);
            return;
        }
        if (build.getTestResult() == null) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", "The build did not produce test results."), 6);
            return;
        }
        Runner.showInJUnitViewInternal(build);
    }

    public static void showInJUnitView(final IBuildPlan plan) {
        if (plan.getLastBuild() != null) {
            TestResultManager.showInJUnitView(plan.getLastBuild());
        } else {
            RefreshOperation operation = BuildsUiInternal.getFactory().getRefreshOperation((IBuildElement)plan);
            operation.addOperationChangeListener(new OperationChangeListener(){

                public void done(OperationChangeEvent event) {
                    event.getOperation().getService().getRealm().asyncExec(() -> {
                        if (plan.getLastBuild() != null) {
                            TestResultManager.showInJUnitView(plan.getLastBuild());
                        }
                    });
                }
            });
            operation.execute();
        }
    }

    static class Runner {
        private static volatile JUnitModel junitModel;

        Runner() {
        }

        static IType findType(String className, IProgressMonitor monitor) throws CoreException {
            final IType[] result = new IType[1];
            TypeNameMatchRequestor nameMatchRequestor = new TypeNameMatchRequestor(){

                public void acceptTypeNameMatch(TypeNameMatch match) {
                    result[0] = match.getType();
                }
            };
            int lastDot = className.lastIndexOf(46);
            char[] packageName = lastDot >= 0 ? className.substring(0, lastDot).toCharArray() : null;
            char[] typeName = (lastDot >= 0 ? className.substring(lastDot + 1) : className).toCharArray();
            SearchEngine engine = new SearchEngine();
            engine.searchAllTypeNames(packageName, 8, typeName, 8, 0, SearchEngine.createWorkspaceScope(), nameMatchRequestor, 3, monitor);
            return result[0];
        }

        static JUnitModel getJUnitModel() {
            if (junitModel == null) {
                try {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.jdt.internal.junit.JUnitCorePlugin");
                    }
                    catch (ClassNotFoundException e) {
                        clazz = Class.forName("org.eclipse.jdt.internal.junit.ui.JUnitPlugin");
                    }
                    Method method = clazz.getDeclaredMethod("getModel", new Class[0]);
                    junitModel = (JUnitModel)method.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    NoClassDefFoundError error = new NoClassDefFoundError("Unable to locate container for JUnitModel");
                    error.initCause(e);
                    throw error;
                }
            }
            return junitModel;
        }

        public static void openInEditor(String className, String testName) {
            AtomicReference result = new AtomicReference();
            try {
                WorkbenchUtil.busyCursorWhile(monitor -> {
                    IMethod method;
                    IType type = Runner.findType(className, monitor);
                    if (type == null) {
                        return;
                    }
                    result.set(type);
                    if (testName != null && (method = type.getMethod(testName, new String[0])) != null && method.exists()) {
                        result.set(method);
                    }
                });
                if (result.get() == null) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", "Failed to locate test in workspace."), 6);
                    return;
                }
                JavaUI.openInEditor((IJavaElement)((IJavaElement)result.get()), (boolean)true, (boolean)true);
            }
            catch (OperationCanceledException e) {
                return;
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", "Failed to locate test in workspace.", (Throwable)e), 7);
                return;
            }
        }

        static void showInJUnitViewInternal(IBuild build) {
            TestResultSession testRunSession = new TestResultSession(build);
            try {
                WorkbenchUtil.busyCursorWhile(monitor -> {
                    JUnitResultGenerator generator = new JUnitResultGenerator(build.getTestResult());
                    generator.setIncludeIgnored(TestResultManager.jUnitSupportIgnoredTests());
                    TestRunHandler handler = new TestRunHandler(testRunSession);
                    try {
                        generator.write((ContentHandler)handler);
                    }
                    catch (SAXException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", "Unexpected parsing error while preparing test results", (Throwable)e));
                    }
                });
            }
            catch (OperationCanceledException e) {
                return;
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", "Unexpected error while processing test results", (Throwable)e), 3);
                return;
            }
            IViewPart part = WorkbenchUtil.showViewInActiveWindow((String)"org.eclipse.jdt.junit.ResultView");
            Runner.showFailuresOnly(part);
            Runner.getJUnitModel().addTestRunSession((TestRunSession)testRunSession);
        }

        static void showFailuresOnly(IViewPart part) {
            try {
                boolean showFailuresOnly = BuildsUiPlugin.getDefault().getPreferenceStore().getBoolean("editor.testResults.failuresOnly");
                Method method = TestRunnerViewPart.class.getDeclaredMethod("setShowFailuresOnly", Boolean.TYPE);
                method.setAccessible(true);
                method.invoke((Object)part, showFailuresOnly);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

