/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import java.util.ArrayList;
import org.eclipse.wst.dtd.core.internal.AttributeList;
import org.eclipse.wst.dtd.core.internal.Comment;
import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.core.internal.Notation;
import org.eclipse.wst.dtd.core.internal.ParameterEntityReference;
import org.eclipse.wst.dtd.core.internal.Unrecognized;

public class NodeList {
    protected DTDFile dtdFile;
    ArrayList listNodes = new ArrayList();
    protected String listType;

    public NodeList(DTDFile dtdFile, String tokenType) {
        this.listType = tokenType;
        this.dtdFile = dtdFile;
    }

    public String getImagePath() {
        if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ELEMENT_TAG") {
            return "icons/full/obj16/fldr_el.gif";
        }
        if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_TAG") {
            return "icons/full/obj16/fldr_ent.gif";
        }
        if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NOTATION_TAG") {
            return "icons/full/obj16/fldr_not.gif";
        }
        if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.COMMENT") {
            return "icons/full/obj16/folder_comments_obj.gif";
        }
        if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ATTLIST_TAG") {
            return "icons/full/obj16/folder_attlist_obj.gif";
        }
        if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.UNKNOWN_CONTENT") {
            return "icons/full/obj16/fldr_unrec.gif";
        }
        return null;
    }

    public String getListType() {
        return this.listType;
    }

    public String getName() {
        if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ELEMENT_TAG") {
            return DTDCoreMessages._UI_LABEL_NODE_LIST_ELEMENTS;
        }
        if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_TAG") {
            return DTDCoreMessages._UI_LABEL_NODE_LIST_ENTITIES;
        }
        if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NOTATION_TAG") {
            return DTDCoreMessages._UI_LABEL_NODE_LIST_NOTATIONS;
        }
        if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.COMMENT") {
            return DTDCoreMessages._UI_LABEL_NODE_LIST_COMMENTS;
        }
        if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ATTLIST_TAG") {
            return DTDCoreMessages._UI_LABEL_NODE_LIST_ATTRIBUTES;
        }
        if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.UNKNOWN_CONTENT") {
            return DTDCoreMessages._UI_LABEL_NODE_LIST_OTHER;
        }
        return "";
    }

    public ArrayList getNodes() {
        this.listNodes.clear();
        for (DTDNode node : this.dtdFile.getNodes()) {
            if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ELEMENT_TAG" && (node instanceof Element || node instanceof ParameterEntityReference)) {
                this.listNodes.add(node);
                continue;
            }
            if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ATTLIST_TAG" && node instanceof AttributeList) {
                this.listNodes.add(node);
                continue;
            }
            if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_TAG" && node instanceof Entity) {
                this.listNodes.add(node);
                continue;
            }
            if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NOTATION_TAG" && node instanceof Notation) {
                this.listNodes.add(node);
                continue;
            }
            if (this.listType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.COMMENT" && node instanceof Comment) {
                this.listNodes.add(node);
                continue;
            }
            if (this.listType != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.UNKNOWN_CONTENT" || !(node instanceof Unrecognized)) continue;
            this.listNodes.add(node);
        }
        return this.listNodes;
    }
}

