/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit6.runner;

import java.text.MessageFormat;
import java.util.function.Function;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestIdentifier;

public class JUnit6Identifier
implements ITestIdentifier {
    private TestIdentifier fTestIdentifier;

    public JUnit6Identifier(TestIdentifier testIdentifier) {
        this.fTestIdentifier = testIdentifier;
    }

    public String getName() {
        return this.fTestIdentifier.getSource().map(this::getName).orElse(this.fTestIdentifier.getDisplayName());
    }

    private String getName(TestSource testSource) {
        if (testSource instanceof ClassSource) {
            return ((ClassSource)testSource).getJavaClass().getName();
        }
        if (testSource instanceof MethodSource) {
            MethodSource methodSource = (MethodSource)testSource;
            return MessageFormat.format("{0}({1})", methodSource.getMethodName(), methodSource.getClassName());
        }
        return null;
    }

    public String getDisplayName() {
        return this.fTestIdentifier.getDisplayName();
    }

    public int hashCode() {
        return this.fTestIdentifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JUnit6Identifier)) {
            return false;
        }
        JUnit6Identifier id = (JUnit6Identifier)obj;
        return this.fTestIdentifier.equals((Object)id.fTestIdentifier);
    }

    public String getParameterTypes() {
        Function<TestSource, String> getParameterTypes = source -> source instanceof MethodSource ? ((MethodSource)source).getMethodParameterTypes() : null;
        return this.fTestIdentifier.getSource().map(getParameterTypes).orElse("");
    }

    public String getUniqueId() {
        return this.fTestIdentifier.getUniqueId();
    }
}

