/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.scannerconfig;

import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.scannerconfig.DiscoveredElement;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

@Deprecated
public class DiscoveredElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private final Color inDirect = new Color((Device)Display.getDefault(), new RGB(170, 170, 170));
    private ImageDescriptor fIncludeIcon;
    private ImageDescriptor fMacroIcon;
    private ImageDescriptor fContainerImage;
    private ImageDescriptor fIncludeGroupIcon;
    private ImageDescriptor fMacroGroupIcon;
    private ImageDescriptor fIncludeAndMacrosFileIcon;
    private ImageDescriptor fIncludeAndMacrosFileGroupIcon;
    private ImageDescriptorRegistry fRegistry;
    private final String DISABLED_LABEL = MakeUIPlugin.getResourceString("ManageScannerConfigDialogCommon.discoveredGroup.annotation.disabled");

    public DiscoveredElementLabelProvider() {
        this.fRegistry = CUIPlugin.getImageDescriptorRegistry();
        this.fContainerImage = CDTSharedImages.getImageDescriptor((String)"icons/obj16/lib_obj.gif");
        this.fIncludeGroupIcon = CDTSharedImages.getImageDescriptor((String)"icons/obj16/includes_container.gif");
        this.fMacroGroupIcon = CDTSharedImages.getImageDescriptor((String)"icons/obj16/define_obj.gif");
        this.fIncludeAndMacrosFileGroupIcon = CDTSharedImages.getImageDescriptor((String)"icons/obj16/include_obj.gif");
        this.fIncludeIcon = CDTSharedImages.getImageDescriptor((String)"icons/obj16/hfolder_obj.gif");
        this.fIncludeAndMacrosFileIcon = CDTSharedImages.getImageDescriptor((String)"icons/obj16/h_file_obj.gif");
        this.fMacroIcon = this.fMacroGroupIcon;
    }

    public Image getImage(Object element) {
        DiscoveredElement elem;
        Image image;
        if (element instanceof DiscoveredElement && (image = this.composeImage(elem = (DiscoveredElement)element)) != null) {
            return image;
        }
        return super.getImage(element);
    }

    private Image composeImage(DiscoveredElement elem) {
        Image image = null;
        switch (elem.getEntryKind()) {
            case 10: {
                image = this.fRegistry.get(this.fIncludeGroupIcon);
                break;
            }
            case 1: {
                image = this.fRegistry.get(this.fContainerImage);
                break;
            }
            case 2: {
                image = this.fRegistry.get(this.fIncludeIcon);
                break;
            }
            case 3: 
            case 11: {
                image = this.fRegistry.get(this.fMacroIcon);
                break;
            }
            case 4: 
            case 5: {
                image = this.fRegistry.get(this.fIncludeAndMacrosFileIcon);
                break;
            }
            case 12: 
            case 13: {
                image = this.fRegistry.get(this.fIncludeAndMacrosFileGroupIcon);
            }
        }
        if (image != null && elem.isRemoved()) {
            image = new DiscoveredElementImageDescriptor(image, true).createImage();
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof DiscoveredElement) {
            DiscoveredElement elem = (DiscoveredElement)element;
            switch (elem.getEntryKind()) {
                case 10: {
                    return CPathEntryMessages.CPElementLabelProvider_Includes;
                }
                case 11: {
                    return CPathEntryMessages.CPElementLabelProvider_PreprocessorSymbols;
                }
                case 12: {
                    return CPathEntryMessages.CPElementLabelProvider_IncludeFiles;
                }
                case 13: {
                    return CPathEntryMessages.CPElementLabelProvider_MacrosFiles;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return elem.getEntry() + (elem.isRemoved() ? this.addAnnotation(this.DISABLED_LABEL) : "");
                }
            }
        }
        return super.getText(element);
    }

    private String addAnnotation(String annotation) {
        return " (" + annotation + ")";
    }

    public Color getForeground(Object element) {
        if (element instanceof DiscoveredElement) {
            DiscoveredElement elem = (DiscoveredElement)element;
            switch (elem.getEntryKind()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (!elem.isRemoved()) break;
                    return this.inDirect;
                }
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    private class DiscoveredElementImageDescriptor
    extends CompositeImageDescriptor {
        private Image fBaseImage;
        private boolean showRemoved;
        private Point fSize;

        public DiscoveredElementImageDescriptor(Image baseImage, boolean removed) {
            this.fBaseImage = baseImage;
            this.showRemoved = removed;
        }

        protected void drawCompositeImage(int width, int height) {
            ImageData bg = this.fBaseImage.getImageData();
            if (bg == null) {
                bg = DEFAULT_IMAGE_DATA;
            }
            this.drawImage(bg, 0, 0);
            this.drawOverlays();
        }

        protected void drawOverlays() {
            ImageData data = null;
            if (this.showRemoved) {
                data = CDTSharedImages.getImageDescriptor((String)"icons/ovr16/error_co.gif").getImageData();
                this.drawImage(data, 0, 0);
            }
        }

        protected Point getSize() {
            if (this.fSize == null) {
                ImageData data = this.fBaseImage.getImageData();
                this.fSize = new Point(data.width, data.height);
            }
            return this.fSize;
        }
    }
}

