/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.document;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistry;

class HTMLDocumentTypeRegistryReader {
    private static final String PLUGIN_ID = "org.eclipse.wst.sse.core";
    private static final String EXTENSION_POINT_ID = "documentTypes";
    private static final String TAG_NAME = "documentType";
    private static final String ATT_PID = "publicID";
    private static final String ATT_SID = "systemID";
    private static final String ATT_IS_XHTML = "isXHTML";
    private static final String ATT_IS_WML = "isWML";
    private static final String ATT_HAS_FRAMESET = "hasFrameset";
    private static final String ATT_NSURI = "namespaceURI";
    private static final String ATT_ENAME = "elementName";
    private static final String ATT_DNAME = "displayName";
    private static final String ATT_IS_DEFAULT_XHTML = "defaultXHTML";
    private static final String ATT_IS_DEFAULT_WML = "defaultWML";
    private static final String ATV_TRUE = "true";
    private static final String ATV_NULL_STRING = "";

    HTMLDocumentTypeRegistryReader() {
    }

    void readRegistry(HTMLDocumentTypeRegistry reg) {
        if (reg == null) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                HTMLDocumentTypeEntry doctype = this.readElement(elements[i]);
                if (doctype != null) {
                    reg.regist(doctype.getPublicId(), doctype);
                }
                ++i;
            }
        }
    }

    private HTMLDocumentTypeEntry readElement(IConfigurationElement element) {
        HTMLDocumentTypeEntry doctype = null;
        String pid = null;
        String sid = null;
        String nsuri = null;
        String root = null;
        boolean xhtml = true;
        boolean frameset = false;
        String dname = null;
        boolean defaultXhtml = false;
        boolean defaultWML = false;
        boolean isWML = false;
        if (element.getName().equals(TAG_NAME)) {
            pid = element.getAttribute(ATT_PID);
            if (pid == null || pid.equals(ATV_NULL_STRING)) {
                return null;
            }
            sid = element.getAttribute(ATT_SID);
            nsuri = element.getAttribute(ATT_NSURI);
            root = element.getAttribute(ATT_ENAME);
            xhtml = this.getBoolean(element, ATT_IS_XHTML);
            frameset = this.getBoolean(element, ATT_HAS_FRAMESET);
            dname = element.getAttribute(ATT_DNAME);
            defaultXhtml = this.getBoolean(element, ATT_IS_DEFAULT_XHTML);
            defaultWML = this.getBoolean(element, ATT_IS_DEFAULT_WML);
            isWML = this.getBoolean(element, ATT_IS_WML);
            doctype = new HTMLDocumentTypeEntry(root, pid, sid, nsuri, xhtml, frameset, dname, defaultXhtml, defaultWML, isWML);
        }
        return doctype;
    }

    private boolean getBoolean(IConfigurationElement element, String att) {
        String value = element.getAttribute(att);
        return value != null && value.equals(ATV_TRUE);
    }
}

