/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.Dereferencable;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class ReflectionCallExpression
extends Expression
implements Dereferencable {
    private Expression receiver;
    private Expression name;
    private CallArgumentsList args;
    private boolean nullSafe;

    public ReflectionCallExpression(int start, int end, Expression receiver, Expression name, CallArgumentsList args) {
        this(start, end, receiver, false, name, args);
    }

    public ReflectionCallExpression(int start, int end, Expression receiver, boolean nullSafe, Expression name, CallArgumentsList args) {
        super(start, end);
        assert (name != null);
        if (args == null) {
            args = new CallArgumentsList();
        }
        this.receiver = receiver;
        this.name = name;
        this.args = args;
        this.nullSafe = nullSafe;
    }

    public int getKind() {
        return 64;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            if (this.receiver != null) {
                this.receiver.traverse(visitor);
            }
            this.name.traverse(visitor);
            this.args.traverse(visitor);
            visitor.endvisit((Expression)this);
        }
    }

    public Expression getName() {
        return this.name;
    }

    public CallArgumentsList getArguments() {
        return this.args;
    }

    public Expression getReceiver() {
        return this.receiver;
    }

    public void setReceiver(Expression receiver) {
        assert (receiver != null);
        this.receiver = receiver;
        this.setStart(receiver.sourceStart());
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }

    public boolean isNullSafe() {
        return this.nullSafe;
    }
}

