/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFileMidx;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndex;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.util.BlockList;

public final class DfsPackFileMidxSingle
extends DfsPackFileMidx {
    private final SingleVOffsetCalculator offsetCalculator;
    private final DfsPackFile pack;
    private final DfsPackFileMidx base;
    private final LocalPackOffset poBuffer = new LocalPackOffset();

    DfsPackFileMidxSingle(DfsBlockCache cache, DfsPackDescription midxDesc, DfsPackFile pack, @Nullable DfsPackFileMidx base) {
        super(cache, midxDesc);
        this.pack = pack;
        this.offsetCalculator = new SingleVOffsetCalculator(this.pack, base != null ? base.getOffsetCalculator() : null);
        this.length = this.offsetCalculator.getMaxOffset();
        this.base = base;
    }

    @Override
    protected DfsPackFileMidx.VOffsetCalculator getOffsetCalculator() {
        return this.offsetCalculator;
    }

    @Override
    public ObjectIdSet asObjectIdSet(DfsReader ctx) throws IOException {
        return this.pack.asObjectIdSet(ctx);
    }

    @Override
    public PackBitmapIndex getBitmapIndex(DfsReader ctx) throws IOException {
        if (this.base != null) {
            return this.base.getBitmapIndex(ctx);
        }
        return this.pack.getBitmapIndex(ctx);
    }

    @Override
    List<DfsPackFile> fullyIncludedIn(DfsReader ctx, BitmapIndex.BitmapBuilder need) throws IOException {
        ArrayList<DfsPackFile> fullyIncluded = new ArrayList<DfsPackFile>();
        List<DfsPackFile> includedPacks = this.pack.fullyIncludedIn(ctx, need);
        if (!includedPacks.isEmpty()) {
            fullyIncluded.addAll(includedPacks);
        }
        if (this.base != null) {
            fullyIncluded.addAll(this.base.fullyIncludedIn(ctx, need));
        }
        return fullyIncluded;
    }

    @Override
    public CommitGraph getCommitGraph(DfsReader ctx) throws IOException {
        return this.pack.getCommitGraph(ctx);
    }

    @Override
    protected int getObjectCount(DfsReader ctx) throws IOException {
        int baseObjectCount = this.base == null ? 0 : this.base.getObjectCount(ctx);
        return (int)this.pack.getPackDescription().getObjectCount() + baseObjectCount;
    }

    @Override
    public List<DfsPackFile> getCoveredPacks() {
        return List.of(this.pack);
    }

    @Override
    public DfsPackFileMidx getMultipackIndexBase() {
        return this.base;
    }

    @Override
    public int findIdxPosition(DfsReader ctx, AnyObjectId id) throws IOException {
        int p = this.pack.findIdxPosition(ctx, id);
        if (p >= 0) {
            int baseObjects = this.base == null ? 0 : this.base.getObjectCount(ctx);
            return p + baseObjects;
        }
        if (this.base == null) {
            return -1;
        }
        return this.base.findIdxPosition(ctx, id);
    }

    @Override
    public boolean hasObject(DfsReader ctx, AnyObjectId id) throws IOException {
        if (this.pack.hasObject(ctx, id)) {
            return true;
        }
        if (this.base == null) {
            return false;
        }
        return this.base.hasObject(ctx, id);
    }

    @Override
    ObjectLoader get(DfsReader ctx, AnyObjectId id) throws IOException {
        ObjectLoader objectLoader = this.pack.get(ctx, id);
        if (objectLoader != null) {
            return objectLoader;
        }
        if (this.base == null) {
            return null;
        }
        return this.base.get(ctx, id);
    }

    private MultiPackIndex.PackOffset find(DfsReader ctx, AnyObjectId id) throws IOException {
        long offset = this.pack.findOffset(ctx, id);
        if (offset >= 0L) {
            this.poBuffer.setOffset(offset);
            return this.poBuffer;
        }
        return null;
    }

    @Override
    long findOffset(DfsReader ctx, AnyObjectId id) throws IOException {
        MultiPackIndex.PackOffset po = this.find(ctx, id);
        if (po != null) {
            return this.offsetCalculator.encode(po);
        }
        if (this.base == null) {
            return -1L;
        }
        return this.base.findOffset(ctx, id);
    }

    @Override
    void resolve(DfsReader ctx, Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) throws IOException {
        this.pack.resolve(ctx, matches, id, matchLimit);
        if (matches.size() < matchLimit && this.base != null) {
            this.base.resolve(ctx, matches, id, matchLimit);
        }
    }

    @Override
    void copyPackAsIs(PackOutputStream out, DfsReader ctx) throws IOException {
        this.pack.copyPackAsIs(out, ctx);
        if (this.base != null) {
            this.base.copyPackAsIs(out, ctx);
        }
    }

    @Override
    long getObjectSize(DfsReader ctx, AnyObjectId id) throws IOException {
        long objectSize = this.pack.getObjectSize(ctx, id);
        if (objectSize >= 0L) {
            return objectSize;
        }
        if (this.base == null) {
            return -1L;
        }
        return this.base.getObjectSize(ctx, id);
    }

    @Override
    boolean hasObjectSizeIndex(DfsReader ctx) {
        return false;
    }

    @Override
    int getObjectSizeIndexThreshold(DfsReader ctx) {
        return Integer.MAX_VALUE;
    }

    @Override
    long getIndexedObjectSize(DfsReader ctx, int idxPosition) {
        return -1L;
    }

    @Override
    List<DfsObjectToPack> findAllFromPack(DfsReader ctx, Iterable<ObjectToPack> objects, boolean skipFound) throws IOException {
        BlockList<DfsObjectToPack> tmp = new BlockList<DfsObjectToPack>();
        BlockList<ObjectToPack> notFoundHere = new BlockList<ObjectToPack>();
        for (ObjectToPack obj : objects) {
            DfsObjectToPack otp = (DfsObjectToPack)obj;
            if (skipFound && otp.isFound()) continue;
            long p = this.offsetCalculator.encode(this.find(ctx, otp));
            if (p < 0L) {
                notFoundHere.add(otp);
                continue;
            }
            otp.setOffset(p);
            tmp.add(otp);
        }
        if (this.base != null && !notFoundHere.isEmpty()) {
            List<DfsObjectToPack> inChain = this.base.findAllFromPack(ctx, notFoundHere, skipFound);
            tmp.addAll(inChain);
        }
        tmp.sort(OFFSET_SORT);
        return tmp;
    }

    private static class LocalPackOffset
    extends MultiPackIndex.PackOffset {
        LocalPackOffset() {
            this.setValues(0, 0L);
        }

        void setOffset(long offset) {
            super.setValues(0, offset);
        }
    }

    static class SingleVOffsetCalculator
    implements DfsPackFileMidx.VOffsetCalculator {
        private final long packSize;
        private final DfsPackFileMidx.DfsPackOffset poBuffer = new DfsPackFileMidx.DfsPackOffset();
        private final DfsPackFileMidx.VOffsetCalculator baseOffsetCalculator;
        private final long baseMaxOffset;

        SingleVOffsetCalculator(DfsPackFile realPack, @Nullable DfsPackFileMidx.VOffsetCalculator base) {
            this.packSize = realPack.getPackDescription().getFileSize(PackExt.PACK);
            this.baseOffsetCalculator = base;
            this.baseMaxOffset = base != null ? base.getMaxOffset() : 0L;
            this.poBuffer.setValues(realPack, this.baseMaxOffset, 0L);
        }

        long encode(MultiPackIndex.PackOffset location) {
            if (location == null) {
                return -1L;
            }
            if (location.getOffset() > this.packSize || location.getPackId() != 0) {
                throw new IllegalArgumentException(String.format("Invalid midx location (packId: %d, offset: %d)", location.getPackId(), location.getOffset()));
            }
            return location.getOffset() + this.baseMaxOffset;
        }

        @Override
        public DfsPackFileMidx.DfsPackOffset decode(long voffset) {
            if (voffset == -1L) {
                return null;
            }
            if (voffset < this.baseMaxOffset) {
                return this.baseOffsetCalculator.decode(voffset);
            }
            long localOffset = voffset - this.baseMaxOffset;
            if (localOffset > this.packSize) {
                throw new IllegalArgumentException("Asking offset beyond limits");
            }
            return this.poBuffer.setMidxOffset(voffset);
        }

        @Override
        public long getMaxOffset() {
            return this.packSize + this.baseMaxOffset;
        }
    }
}

