/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.StatusListener;

public class CollectingStatusListener
implements StatusListener {
    private final AtomicLong fileSize = new AtomicLong();
    private final AtomicLong recordCount = new AtomicLong();
    private final AtomicLong byteCount = new AtomicLong();
    private final AtomicBoolean completionStatus = new AtomicBoolean();
    private final AtomicReference<Throwable> failedThrowable = new AtomicReference();

    @Override
    public void onInit(long fileSize) {
        this.fileSize.set(fileSize);
    }

    public long getFileSize() {
        return this.fileSize.get();
    }

    @Override
    public void onReadRecord() {
        this.recordCount.incrementAndGet();
    }

    public long getRecordCount() {
        return this.recordCount.longValue();
    }

    @Override
    public void onReadBytes(int bytes) {
        this.byteCount.addAndGet(bytes);
    }

    public long getByteCount() {
        return this.byteCount.longValue();
    }

    @Override
    public void onComplete() {
        this.completionStatus.set(true);
    }

    public boolean isCompleted() {
        return this.completionStatus.get();
    }

    @Override
    public void onError(Throwable throwable) {
        this.failedThrowable.set(throwable);
    }

    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.failedThrowable.get());
    }

    public String toString() {
        long byteCntVal = this.byteCount.longValue();
        long currentFileSize = this.fileSize.get();
        double percentage = (double)byteCntVal * 100.0 / (double)currentFileSize;
        return "Read %,d records and %,d of %,d bytes (%.2f %%)".formatted(this.recordCount.longValue(), byteCntVal, currentFileSize, percentage);
    }
}

