/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.labeling;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedField;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImageAdornments;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImages2;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XbaseLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    private XbaseImages2 images;
    @Inject
    private UIStrings uiStrings;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private XbaseImageAdornments adornments;
    @Inject
    private CommonTypeComputationServices services;

    @Inject
    public XbaseLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected ImageDescriptor imageDescriptor(Object obj) {
        Preconditions.checkNotNull((Object)obj);
        if (obj instanceof JvmConstructor) {
            return this._imageDescriptor((JvmConstructor)obj);
        }
        if (obj instanceof JvmOperation) {
            return this._imageDescriptor((JvmOperation)obj);
        }
        if (obj instanceof JvmAnnotationType) {
            return this._imageDescriptor((JvmAnnotationType)obj);
        }
        if (obj instanceof JvmEnumerationType) {
            return this._imageDescriptor((JvmEnumerationType)obj);
        }
        if (obj instanceof JvmField) {
            return this._imageDescriptor((JvmField)obj);
        }
        if (obj instanceof JvmGenericType) {
            return this._imageDescriptor((JvmGenericType)obj);
        }
        if (obj instanceof JvmTypeParameter) {
            return this._imageDescriptor((JvmTypeParameter)obj);
        }
        if (obj instanceof JvmFormalParameter) {
            return this._imageDescriptor((JvmFormalParameter)obj);
        }
        if (obj instanceof XVariableDeclaration) {
            return this._imageDescriptor((XVariableDeclaration)obj);
        }
        if (obj instanceof IResolvedConstructor) {
            return this._imageDescriptor((IResolvedConstructor)obj);
        }
        if (obj instanceof IResolvedOperation) {
            return this._imageDescriptor((IResolvedOperation)obj);
        }
        if (obj instanceof XImportDeclaration) {
            return this._imageDescriptor((XImportDeclaration)obj);
        }
        if (obj instanceof XImportSection) {
            return this._imageDescriptor((XImportSection)obj);
        }
        if (obj instanceof IResolvedField) {
            return this._imageDescriptor((IResolvedField)obj);
        }
        return this._imageDescriptor(obj);
    }

    protected ImageDescriptor _imageDescriptor(Object element) {
        return null;
    }

    protected ImageDescriptor _imageDescriptor(XImportSection importSection) {
        return this.images.forImportContainer();
    }

    protected ImageDescriptor _imageDescriptor(XImportDeclaration importDeclaration) {
        return this.images.forImport();
    }

    protected ImageDescriptor _imageDescriptor(JvmGenericType genericType) {
        return genericType.isInterface() ? this.images.forInterface(genericType.getVisibility(), this.adornments.get((JvmIdentifiableElement)genericType)) : this.images.forClass(genericType.getVisibility(), this.adornments.get((JvmIdentifiableElement)genericType));
    }

    protected ImageDescriptor _imageDescriptor(JvmEnumerationType enumerationType) {
        return this.images.forEnum(enumerationType.getVisibility(), this.adornments.get((JvmIdentifiableElement)enumerationType));
    }

    protected ImageDescriptor _imageDescriptor(JvmAnnotationType annotationType) {
        return this.images.forAnnotation(annotationType.getVisibility(), this.adornments.get((JvmIdentifiableElement)annotationType));
    }

    protected ImageDescriptor _imageDescriptor(JvmOperation operation) {
        return this.images.forOperation(operation.getVisibility(), this.adornments.get((JvmIdentifiableElement)operation));
    }

    protected ImageDescriptor _imageDescriptor(IResolvedOperation operation) {
        return this.imageDescriptor(operation.getDeclaration());
    }

    protected ImageDescriptor _imageDescriptor(JvmConstructor constructor) {
        return this.images.forConstructor(constructor.getVisibility(), this.adornments.get((JvmIdentifiableElement)constructor));
    }

    protected ImageDescriptor _imageDescriptor(IResolvedConstructor constructor) {
        return this._imageDescriptor(constructor.getDeclaration());
    }

    protected ImageDescriptor _imageDescriptor(IResolvedField field) {
        return this._imageDescriptor(field.getDeclaration());
    }

    protected ImageDescriptor _imageDescriptor(JvmField field) {
        return this.images.forField(field.getVisibility(), this.adornments.get((JvmIdentifiableElement)field));
    }

    protected ImageDescriptor _imageDescriptor(JvmFormalParameter parameter) {
        return this.images.forLocalVariable(this.adornments.get((JvmIdentifiableElement)parameter));
    }

    protected ImageDescriptor _imageDescriptor(XVariableDeclaration variableDeclaration) {
        return this.images.forLocalVariable(this.adornments.get((JvmIdentifiableElement)variableDeclaration));
    }

    protected ImageDescriptor _imageDescriptor(JvmTypeParameter parameter) {
        return this.images.forTypeParameter(this.adornments.get((JvmIdentifiableElement)parameter));
    }

    protected String text(JvmConstructor constructor) {
        return "new" + this.uiStrings.parameters((JvmIdentifiableElement)constructor);
    }

    protected String text(JvmGenericType genericType) {
        return genericType.getSimpleName();
    }

    protected Object text(JvmOperation element) {
        return this.signature(element.getSimpleName(), (JvmIdentifiableElement)element);
    }

    protected Object text(IResolvedOperation element) {
        String returnTypeString = element.getResolvedReturnType().getSimpleName();
        String decoratedPart = " : " + returnTypeString;
        if (!element.getTypeParameters().isEmpty()) {
            decoratedPart = " <" + this.uiStrings.toString((Iterable)element.getTypeParameters()) + "> : " + returnTypeString;
        }
        String styledString = element.getDeclaration().getSimpleName() + element.getResolvedParameterTypes().stream().map(type -> type.getHumanReadableName()).collect(Collectors.joining(", ", "(", ")"));
        return new StyledString(styledString).append(new StyledString(decoratedPart, StyledString.DECORATIONS_STYLER));
    }

    protected Object text(IResolvedConstructor constructor) {
        String styledString = constructor.getResolvedParameterTypes().stream().map(type -> type.getHumanReadableName()).collect(Collectors.joining(", ", "new(", ")"));
        return new StyledString(styledString);
    }

    protected Object text(IResolvedField field) {
        return new StyledString(field.getSimpleSignature() + " : " + field.getResolvedType().getHumanReadableName());
    }

    protected Object text(JvmField field) {
        return field.getSimpleName() + " : " + field.getType().getSimpleName();
    }

    protected String text(JvmFormalParameter parameter) {
        JvmTypeReference parameterType = parameter.getParameterType();
        if (parameterType == null) {
            return parameter.getName();
        }
        return parameterType.getSimpleName() + " " + parameter.getName();
    }

    protected String text(XImportDeclaration importDeclaration) {
        StringBuilder builder = new StringBuilder();
        builder.append(importDeclaration.getImportedTypeName());
        if (importDeclaration.isWildcard()) {
            builder.append(".*");
        } else if (importDeclaration.getMemberName() != null) {
            builder.append(".");
            builder.append(importDeclaration.getMemberName());
        }
        return builder.toString();
    }

    protected String text(XImportSection importSection) {
        return "import declarations";
    }

    protected String text(XVariableDeclaration variableDeclaration) {
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)variableDeclaration);
        LightweightTypeReference type = resolvedTypes.getActualType((JvmIdentifiableElement)variableDeclaration);
        if (type != null) {
            return type.getHumanReadableName() + " " + variableDeclaration.getName();
        }
        return variableDeclaration.getName();
    }

    protected StyledString signature(String simpleName, JvmIdentifiableElement element) {
        String typeParam;
        JvmTypeReference returnType = null;
        if (element instanceof JvmOperation) {
            returnType = ((JvmOperation)element).getReturnType();
        } else if (element instanceof JvmField) {
            returnType = ((JvmField)element).getType();
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, (EObject)element);
        String returnTypeString = returnType == null ? "void" : owner.toLightweightTypeReference(returnType).getHumanReadableName();
        String decoratedPart = " : " + returnTypeString;
        String string = typeParam = this.uiStrings.typeParameters(element) != null ? this.uiStrings.typeParameters(element) : "";
        if (!typeParam.isEmpty()) {
            decoratedPart = " " + typeParam + " : " + returnTypeString;
        }
        return new StyledString(simpleName + this.uiStrings.parameters(element)).append(new StyledString(decoratedPart, StyledString.DECORATIONS_STYLER));
    }

    protected Object doGetImage(Object element) {
        if (element != null) {
            ImageDescriptor imageDescriptor = this.imageDescriptor(element);
            return imageDescriptor != null ? imageDescriptor : super.doGetImage(element);
        }
        return null;
    }

    protected IBatchTypeResolver getTypeResolver() {
        return this.typeResolver;
    }
}

