/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.manipulation.CUCorrectionProposalCore;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class AddJavadocCommentProposalCore
extends CUCorrectionProposalCore {
    private final int fInsertPosition;
    private final String fComment;

    public AddJavadocCommentProposalCore(String name, ICompilationUnit cu, int relevance, int insertPosition, String comment) {
        super(name, cu, relevance);
        this.fInsertPosition = insertPosition;
        this.fComment = comment;
    }

    @Override
    public void addEdits(IDocument document, TextEdit rootEdit) throws CoreException {
        try {
            String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            ICompilationUnit unit = this.getCompilationUnit();
            IRegion region = document.getLineInformationOfOffset(this.fInsertPosition);
            String lineContent = document.get(region.getOffset(), region.getLength());
            String indentString = Strings.getIndentString(lineContent, unit);
            String str = Strings.changeIndent(this.fComment, 0, unit, indentString, lineDelimiter);
            InsertEdit edit = new InsertEdit(this.fInsertPosition, str);
            rootEdit.addChild((TextEdit)edit);
            if (this.fComment.charAt(this.fComment.length() - 1) != '\n') {
                rootEdit.addChild((TextEdit)new InsertEdit(this.fInsertPosition, lineDelimiter));
                rootEdit.addChild((TextEdit)new InsertEdit(this.fInsertPosition, indentString));
            }
        }
        catch (BadLocationException e) {
            throw new CoreException(JavaUIStatus.createError(4, e));
        }
    }
}

