/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.generator;

import java.util.Arrays;
import java.util.List;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.builder.expression.ExpressionBuilder;
import org.eclipse.scout.sdk.core.java.builder.expression.IExpressionBuilder;
import org.eclipse.scout.sdk.core.java.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.TypeGenerator;
import org.eclipse.scout.sdk.core.java.imports.ImportCollector;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.java.model.api.IArrayMetaValue;
import org.eclipse.scout.sdk.core.java.model.api.IField;
import org.eclipse.scout.sdk.core.java.model.api.IImport;
import org.eclipse.scout.sdk.core.java.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.IUnresolvedType;
import org.eclipse.scout.sdk.core.java.model.api.MetaValueType;
import org.eclipse.scout.sdk.core.java.transformer.IWorkingCopyTransformer;

public final class SimpleGenerators {
    private SimpleGenerators() {
    }

    public static ISourceGenerator<ISourceBuilder<?>> createImportGenerator(IImport imp) {
        return ISourceGenerator.raw((CharSequence)ImportCollector.createImportDeclaration(imp.isStatic(), imp.name()));
    }

    public static ISourceGenerator<IExpressionBuilder<?>> createMetaValueGenerator(IMetaValue mv, IWorkingCopyTransformer transformer) {
        return switch (mv.type()) {
            case MetaValueType.Null -> b -> b.append("null");
            case MetaValueType.Int -> b -> b.append(mv.as(Integer.class));
            case MetaValueType.Byte -> b -> b.append(mv.as(Byte.class).byteValue());
            case MetaValueType.Short -> b -> b.append(mv.as(Short.class).shortValue());
            case MetaValueType.Char -> b -> ((IExpressionBuilder)((IExpressionBuilder)b.append('\'')).append(mv.as(Character.class).charValue())).append('\'');
            case MetaValueType.Float -> b -> ((IExpressionBuilder)b.append(mv.as(Float.class).floatValue())).append('f');
            case MetaValueType.Double -> b -> b.append(mv.as(Double.class));
            case MetaValueType.Bool -> b -> b.append(mv.as(Boolean.class));
            case MetaValueType.Long -> b -> ((IExpressionBuilder)b.append(mv.as(Long.class))).append('L');
            case MetaValueType.String -> b -> b.stringLiteral(mv.as(String.class));
            case MetaValueType.Type -> b -> b.classLiteral(mv.as(IType.class).reference(true));
            case MetaValueType.Enum -> {
                IField field = mv.as(IField.class);
                yield b -> b.enumValue(field.requireDeclaringType().name(), field.elementName());
            }
            case MetaValueType.Annotation -> IWorkingCopyTransformer.transformAnnotation(mv.as(IAnnotation.class), transformer).map(g -> b -> b.append(g)).orElseGet(ISourceGenerator::empty);
            case MetaValueType.Array -> SimpleGenerators.createArrayMetaValueGenerator((IArrayMetaValue)mv, transformer);
            default -> b -> ((IExpressionBuilder)((IExpressionBuilder)((IExpressionBuilder)((IExpressionBuilder)b.append("UNKNOWN(")).append(mv.type().toString())).append(", ")).append(mv.toString())).append(')');
        };
    }

    public static ISourceGenerator<IExpressionBuilder<?>> createArrayMetaValueGenerator(IArrayMetaValue mv, IWorkingCopyTransformer transformer) {
        IMetaValue[] metaArray = mv.metaValueArray();
        List<ISourceGenerator> generators = Arrays.stream(metaArray).map(m -> SimpleGenerators.createMetaValueGenerator(m, transformer)).map(g -> g.generalize(ExpressionBuilder::create)).toList();
        boolean useNewlines = metaArray.length > 0 && (metaArray[0].type() == MetaValueType.Array || metaArray[0].type() == MetaValueType.Annotation);
        return b -> b.array(generators.stream(), useNewlines);
    }

    public static ISourceGenerator<IExpressionBuilder<?>> createAnnotationElementGenerator(IAnnotationElement ae, IWorkingCopyTransformer transformer) {
        if (ae.isDefault()) {
            return ISourceGenerator.empty();
        }
        return b -> ((IExpressionBuilder)((IExpressionBuilder)b.append(ae.elementName())).equalSign()).append(ae.value().toWorkingCopy(transformer).generalize(ExpressionBuilder::create));
    }

    public static ITypeGenerator<?> createUnresolvedTypeGenerator(IUnresolvedType ut, IWorkingCopyTransformer transformer) {
        return ut.type().map(t -> TypeGenerator.create(t, transformer)).orElseGet(() -> (ITypeGenerator)TypeGenerator.create().setDeclaringFullyQualifiedName(JavaTypes.qualifier(ut.name().replace('$', '.'))).withElementName(ut.elementName()));
    }
}

