/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;

public abstract class AbstractJavaBreakpointEditor {
    private final ListenerList<IPropertyListener> fListeners = new ListenerList();
    private boolean fDirty = false;
    private boolean fMnemonics = true;
    private boolean fSuppressPropertyChanges = false;

    public void addPropertyListener(IPropertyListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void setMnemonics(boolean mnemonics) {
        this.fMnemonics = mnemonics;
    }

    protected boolean isMnemonics() {
        return this.fMnemonics;
    }

    protected String processMnemonics(String text) {
        if (this.isMnemonics()) {
            return text;
        }
        return LegacyActionTools.removeMnemonics((String)text);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public abstract Control createControl(Composite var1);

    protected void dispose() {
        this.fListeners.clear();
    }

    public abstract void setFocus();

    public abstract void doSave() throws CoreException;

    public abstract IStatus getStatus();

    public boolean isDirty() {
        return this.fDirty;
    }

    protected void setDirty(int propId) {
        this.fDirty = true;
        this.firePropertyChange(propId);
    }

    protected void setDirty(boolean dirty) {
        if (this.fDirty != dirty) {
            this.fDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    protected void firePropertyChange(int propId) {
        if (!this.fSuppressPropertyChanges) {
            for (IPropertyListener listener : this.fListeners) {
                listener.propertyChanged((Object)this, propId);
            }
        }
    }

    public abstract Object getInput();

    public abstract void setInput(Object var1) throws CoreException;

    protected void suppressPropertyChanges(boolean suppress) {
        this.fSuppressPropertyChanges = suppress;
    }
}

