/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.dto;

import java.util.Optional;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.builder.comment.IJavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.java.generator.compilationunit.CompilationUnitGenerator;
import org.eclipse.scout.sdk.core.java.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.s.dto.AbstractDtoGenerator;
import org.eclipse.scout.sdk.core.s.dto.CompositeFormDataGenerator;
import org.eclipse.scout.sdk.core.s.dto.table.PageDataGenerator;
import org.eclipse.scout.sdk.core.s.dto.table.TableFieldDataGenerator;
import org.eclipse.scout.sdk.core.s.dto.table.TableRowDataGenerator;
import org.eclipse.scout.sdk.core.s.java.annotation.DataAnnotationDescriptor;
import org.eclipse.scout.sdk.core.s.java.annotation.FormDataAnnotationDescriptor;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.generator.annotation.ScoutAnnotationGenerator;

public final class DtoGeneratorFactory {
    private static final String GENERATED_MSG = "This class is auto generated by the Scout SDK. No manual modifications recommended.";
    private static final String GENERATED_JAVADOC = "<b>NOTE:</b><br>\nThis class is auto generated by the Scout SDK. No manual modifications recommended.";

    private DtoGeneratorFactory() {
    }

    public static Optional<ICompilationUnitGenerator<?>> createTableRowDataGenerator(IType modelType, IJavaEnvironment sharedEnv) {
        return DataAnnotationDescriptor.of(modelType).flatMap(dataAnnotation -> DtoGeneratorFactory.createTableRowDataGenerator(modelType, sharedEnv, dataAnnotation));
    }

    public static Optional<ICompilationUnitGenerator<?>> createTableRowDataGenerator(IType modelType, IJavaEnvironment sharedEnv, DataAnnotationDescriptor dataAnnotation) {
        if (modelType == null || dataAnnotation == null || sharedEnv == null) {
            return Optional.empty();
        }
        TableRowDataGenerator rowDataTypeSrc = (TableRowDataGenerator)((Object)new TableRowDataGenerator(modelType, modelType, sharedEnv).withExtendsAnnotationIfNecessary(dataAnnotation.getAnnotationHolder()));
        String targetPackage = dataAnnotation.getDataType().requireCompilationUnit().containingPackage().elementName();
        String targetName = dataAnnotation.getDataType().elementName();
        return Optional.of(DtoGeneratorFactory.createDtoCuGenerator(modelType, targetName, targetPackage, rowDataTypeSrc));
    }

    public static Optional<ICompilationUnitGenerator<?>> createPageDataGenerator(IType modelType, IJavaEnvironment sharedEnv) {
        return DataAnnotationDescriptor.of(modelType).flatMap(dataAnnotation -> DtoGeneratorFactory.createPageDataGenerator(modelType, sharedEnv, dataAnnotation));
    }

    public static Optional<ICompilationUnitGenerator<?>> createPageDataGenerator(IType modelType, IJavaEnvironment sharedEnv, DataAnnotationDescriptor dataAnnotation) {
        if (modelType == null || dataAnnotation == null || sharedEnv == null) {
            return Optional.empty();
        }
        PageDataGenerator pageDataTypeSrc = new PageDataGenerator(modelType, dataAnnotation, sharedEnv);
        String targetPackage = dataAnnotation.getDataType().requireCompilationUnit().containingPackage().elementName();
        String targetName = dataAnnotation.getDataType().elementName();
        return Optional.of(DtoGeneratorFactory.createDtoCuGenerator(modelType, targetName, targetPackage, pageDataTypeSrc));
    }

    public static Optional<ICompilationUnitGenerator<?>> createFormDataGenerator(IType modelType, IJavaEnvironment sharedEnv) {
        return DtoGeneratorFactory.createFormDataGenerator(modelType, sharedEnv, FormDataAnnotationDescriptor.of(modelType));
    }

    public static Optional<ICompilationUnitGenerator<?>> createFormDataGenerator(IType modelType, IJavaEnvironment sharedEnv, FormDataAnnotationDescriptor formDataAnnotation) {
        if (!FormDataAnnotationDescriptor.isCreate(formDataAnnotation) || modelType == null || sharedEnv == null) {
            return Optional.empty();
        }
        IType superType = formDataAnnotation.getSuperType();
        if (superType == null) {
            return Optional.empty();
        }
        IScoutApi scoutApi = (IScoutApi)modelType.javaEnvironment().requireApi(IScoutApi.class);
        AbstractDtoGenerator formDataTypeSrc = superType.isInstanceOf((ITypeNameSupplier)scoutApi.AbstractTableFieldBeanData()) ? new TableFieldDataGenerator(modelType, formDataAnnotation, sharedEnv) : new CompositeFormDataGenerator(modelType, formDataAnnotation, sharedEnv);
        String targetPackage = formDataAnnotation.getFormDataType().requireCompilationUnit().containingPackage().elementName();
        String targetName = formDataAnnotation.getFormDataType().elementName();
        return Optional.of(DtoGeneratorFactory.createDtoCuGenerator(modelType, targetName, targetPackage, formDataTypeSrc.withExtendsAnnotationIfNecessary(formDataAnnotation.getAnnotationOwnerAsType())));
    }

    private static ICompilationUnitGenerator<?> createDtoCuGenerator(IType modelType, String targetPrimaryTypeName, String targetPackage, ITypeGenerator<?> dtoGeneratorForModel) {
        return ((ICompilationUnitGenerator)CompilationUnitGenerator.create().withPackageName(targetPackage).withElementName(targetPrimaryTypeName).withComment(IJavaElementCommentBuilder::appendDefaultElementComment)).withType((ITypeGenerator)((ITypeGenerator)((ITypeGenerator)dtoGeneratorForModel.withElementName(targetPrimaryTypeName)).withComment(b -> b.appendJavaDocComment(GENERATED_JAVADOC))).withAnnotation(ScoutAnnotationGenerator.createGenerated(modelType.name(), GENERATED_MSG)), new Object[0]);
    }
}

