/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.objects;

import java.util.function.Predicate;
import org.eclipse.scout.sdk.core.s.model.js.AbstractScoutJsElementQuery;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsElementSpliterator;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.s.model.js.objects.IScoutJsObject;
import org.eclipse.scout.sdk.core.typescript.model.api.Modifier;

public class ScoutJsObjectQuery
extends AbstractScoutJsElementQuery<IScoutJsObject, ScoutJsObjectQuery> {
    private String m_objectType;
    private Modifier m_requiredModifier;
    private Modifier m_notAllowedModifier;

    public ScoutJsObjectQuery(ScoutJsModel model) {
        super(model);
    }

    public ScoutJsObjectQuery withObjectType(String objectType) {
        this.m_objectType = objectType;
        return this;
    }

    protected String objectType() {
        return this.m_objectType;
    }

    public ScoutJsObjectQuery withoutModifier(Modifier modifier) {
        this.m_notAllowedModifier = modifier;
        return this;
    }

    protected Modifier getNotAllowedModifier() {
        return this.m_notAllowedModifier;
    }

    public ScoutJsObjectQuery withModifier(Modifier modifier) {
        this.m_requiredModifier = modifier;
        return this;
    }

    protected Modifier getRequiredModifier() {
        return this.m_requiredModifier;
    }

    @Override
    protected ScoutJsElementSpliterator<IScoutJsObject> createSpliterator() {
        return new ScoutJsElementSpliterator<IScoutJsObject>(this.model(), this.isIncludeSelf(), this.isIncludeDependencies(), ScoutJsModel::scoutObjects);
    }

    @Override
    protected Predicate<IScoutJsObject> createFilter() {
        Modifier notAllowedModifier;
        Modifier requiredModifier;
        Predicate<IScoutJsObject> result = super.createFilter();
        Object objectType = this.objectType();
        if (objectType != null) {
            if (((String)objectType).indexOf(46) < 0) {
                objectType = "scout." + (String)objectType;
            }
            String objectTypeFinal = objectType;
            result = ScoutJsObjectQuery.appendOrCreateFilter(result, o -> o.qualifiedName().equals(objectTypeFinal));
        }
        if ((requiredModifier = this.getRequiredModifier()) != null) {
            result = ScoutJsObjectQuery.appendOrCreateFilter(result, o -> o.declaringClass().hasModifier(requiredModifier));
        }
        if ((notAllowedModifier = this.getNotAllowedModifier()) != null) {
            result = ScoutJsObjectQuery.appendOrCreateFilter(result, o -> !o.declaringClass().hasModifier(notAllowedModifier));
        }
        return result;
    }
}

