/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.structured;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.scout.sdk.core.java.model.api.IField;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.model.api.IMember;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.s.structured.IStructuredType;
import org.eclipse.scout.sdk.core.s.structured.StructuredType;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class Wellformer {
    protected static final Pattern EMPTY_COMMENT_REGEX = Pattern.compile("/\\*\\*[/*\\s]+", 40);
    private static final Pattern LEADING_SPACES_REGEX = Pattern.compile("\\s*$");
    private static final Pattern TRAILING_SPACES_REGEX = Pattern.compile("^\\s*");
    private final String m_lineDelimiter;
    private final boolean m_recursive;

    public Wellformer(String lineDelimiter, boolean recursive) {
        this.m_lineDelimiter = lineDelimiter;
        this.m_recursive = recursive;
    }

    protected static List<IJavaElement> getChildren(IType t) {
        List fields = t.fields().stream().toList();
        List innerTypes = t.innerTypes().stream().toList();
        List methods = t.methods().stream().toList();
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(fields.size() + innerTypes.size() + methods.size());
        result.addAll(fields);
        result.addAll(methods);
        result.addAll(innerTypes);
        return result;
    }

    protected void appendFields(Iterable<IField> fields, StringBuilder builder) {
        for (IField f : fields) {
            builder.append(this.m_lineDelimiter);
            this.appendMemberSource((IMember)f, builder);
        }
    }

    protected void appendMemberSource(IMember m, StringBuilder builder) {
        SourceRange javaDoc;
        if (m.source().isEmpty()) {
            return;
        }
        CharSequence source = ((SourceRange)m.source().orElseThrow()).asCharSequence();
        if (m.javaDoc().isPresent() && EMPTY_COMMENT_REGEX.matcher((javaDoc = (SourceRange)m.javaDoc().orElseThrow()).asCharSequence()).matches()) {
            int javaDocEndRel = javaDoc.length() + 1 + this.m_lineDelimiter.length();
            builder.append("/**").append(this.m_lineDelimiter).append(" *").append(this.m_lineDelimiter).append(" */");
            builder.append(source.subSequence(javaDocEndRel, source.length()));
            return;
        }
        builder.append(source);
    }

    protected void appendMethods(Iterable<IMethod> methods, StringBuilder builder) {
        for (IMethod m : methods) {
            builder.append(this.m_lineDelimiter);
            this.appendMemberSource((IMember)m, builder);
        }
    }

    protected void appendTypes(Iterable<IType> types, StringBuilder builder, boolean recursive) {
        for (IType t : types) {
            if (recursive) {
                builder.append(this.m_lineDelimiter).append(this.m_lineDelimiter);
                this.buildSource(t, builder);
                continue;
            }
            builder.append(this.m_lineDelimiter);
            this.appendMemberSource((IMember)t, builder);
        }
    }

    public boolean buildSource(IType type, StringBuilder builder) {
        if (type.source().isEmpty()) {
            return false;
        }
        SourceRange typeSource = (SourceRange)type.source().orElseThrow();
        CharSequence src = typeSource.asCharSequence();
        List<IJavaElement> children = Wellformer.getChildren(type);
        if (children.isEmpty()) {
            builder.append(src);
        } else {
            int start = Integer.MAX_VALUE;
            int end = -1;
            for (IJavaElement e : children) {
                if (!e.source().isPresent()) continue;
                SourceRange eRange = (SourceRange)e.source().orElseThrow();
                start = Math.min(start, eRange.start() - typeSource.start());
                end = Math.max(end, eRange.start() + eRange.length() - typeSource.start());
            }
            if (start > end) {
                builder.append(src);
            } else {
                CharSequence classHeader = src.subSequence(0, start);
                classHeader = LEADING_SPACES_REGEX.matcher(classHeader).replaceAll("");
                builder.append(classHeader).append(this.m_lineDelimiter);
                IStructuredType structureHelper = StructuredType.of(type);
                this.appendFields(structureHelper.getElements(IStructuredType.Categories.FIELD_LOGGER, IField.class), builder);
                this.appendFields(structureHelper.getElements(IStructuredType.Categories.FIELD_STATIC, IField.class), builder);
                this.appendFields(structureHelper.getElements(IStructuredType.Categories.FIELD_MEMBER, IField.class), builder);
                this.appendFields(structureHelper.getElements(IStructuredType.Categories.FIELD_UNKNOWN, IField.class), builder);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.ENUM, IType.class), builder, false);
                this.appendMethods(structureHelper.getElements(IStructuredType.Categories.METHOD_CONSTRUCTOR, IMethod.class), builder);
                this.appendMethods(structureHelper.getElements(IStructuredType.Categories.METHOD_CONFIG_PROPERTY, IMethod.class), builder);
                this.appendMethods(structureHelper.getElements(IStructuredType.Categories.METHOD_CONFIG_EXEC, IMethod.class), builder);
                this.appendMethods(structureHelper.getElements(IStructuredType.Categories.METHOD_FORM_DATA_BEAN, IMethod.class), builder);
                this.appendMethods(structureHelper.getElements(IStructuredType.Categories.METHOD_OVERRIDDEN, IMethod.class), builder);
                this.appendMethods(structureHelper.getElements(IStructuredType.Categories.METHOD_START_HANDLER, IMethod.class), builder);
                this.appendMethods(structureHelper.getElements(IStructuredType.Categories.METHOD_INNER_TYPE_GETTER, IMethod.class), builder);
                this.appendMethods(structureHelper.getElements(IStructuredType.Categories.METHOD_LOCAL_BEAN, IMethod.class), builder);
                this.appendMethods(structureHelper.getElements(IStructuredType.Categories.METHOD_UNCATEGORIZED, IMethod.class), builder);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_FORM_FIELD, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_COLUMN, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_CODE, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_FORM, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_TABLE, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_TREE, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_CALENDAR, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_CALENDAR_ITEM_PROVIDER, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_WIZARD, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_WIZARD_STEP, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_MENU, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_VIEW_BUTTON, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_KEYSTROKE, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_FORM_HANDLER, IType.class), builder, this.m_recursive);
                this.appendTypes(structureHelper.getElements(IStructuredType.Categories.TYPE_UNCATEGORIZED, IType.class), builder, false);
                CharSequence classTail = src.subSequence(end, src.length());
                classTail = TRAILING_SPACES_REGEX.matcher(classTail).replaceAll("");
                builder.append(this.m_lineDelimiter);
                builder.append(classTail);
            }
        }
        return true;
    }
}

