/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.api.tools.internal.builder.AbstractProblemDetector;
import org.eclipse.pde.api.tools.internal.model.ApiType;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.util.Signatures;

public abstract class AbstractIllegalTypeReference
extends AbstractProblemDetector {
    private final Map<String, String> fIllegalTypes = new HashMap<String, String>();

    void addIllegalType(IReferenceTypeDescriptor type, String componentId) {
        this.fIllegalTypes.put(type.getQualifiedName(), componentId);
    }

    @Override
    public boolean considerReference(IReference reference, IProgressMonitor monitor) {
        if (super.considerReference(reference, monitor) && this.fIllegalTypes.containsKey(reference.getReferencedTypeName())) {
            this.retainReference(reference);
            return true;
        }
        return false;
    }

    protected boolean isIllegalType(IReference reference) {
        return this.fIllegalTypes.containsKey(reference.getReferencedTypeName());
    }

    @Override
    protected boolean isProblem(IReference reference, IProgressMonitor monitor) {
        if (!super.isProblem(reference, monitor)) {
            return false;
        }
        IApiMember type = reference.getResolvedReference();
        boolean isConstructorVirtualMethod = false;
        if (type.getName().equals("<init>") && reference.getReferenceKind() == 256 && type.getParent() != null) {
            isConstructorVirtualMethod = true;
        }
        String componentId = this.fIllegalTypes.get(isConstructorVirtualMethod ? type.getParent().getName() : type.getName());
        return this.isReferenceFromComponent(reference, componentId);
    }

    @Override
    protected Position getSourceRange(IType type, IDocument doc, IReference reference) throws CoreException, BadLocationException {
        IApiMember member = reference.getMember();
        if (member.getType() == 2) {
            ApiType ltype = (ApiType)member;
            IMethod method = null;
            if (ltype.isAnonymous()) {
                this.getEnclosingMethod(type, reference, doc);
                if (reference.getLineNumber() < 0) {
                    return this.defaultSourcePosition(type, reference);
                }
                String name = this.getSimpleTypeName(reference.getResolvedReference());
                Position pos = this.getMethodNameRange(true, name, doc, reference);
                if (pos == null) {
                    return this.defaultSourcePosition(type, reference);
                }
                return pos;
            }
            if (ltype.isLocal()) {
                String name = ltype.getSimpleName();
                ICompilationUnit cunit = type.getCompilationUnit();
                if (cunit.isWorkingCopy()) {
                    cunit.reconcile(AST.getJLSLatest(), false, null, null);
                }
                IType localtype = type;
                method = this.getEnclosingMethod(type, reference, doc);
                if (method != null) {
                    localtype = method.getType(name, 1);
                }
                if (localtype.exists()) {
                    ISourceRange range = localtype.getNameRange();
                    return new Position(range.getOffset(), range.getLength());
                }
                return this.defaultSourcePosition(type, reference);
            }
        }
        ISourceRange range = type.getNameRange();
        Position pos = null;
        if (range != null) {
            pos = new Position(range.getOffset(), range.getLength());
        }
        if (pos == null) {
            return this.defaultSourcePosition(type, reference);
        }
        return pos;
    }

    @Override
    protected int getElementType(IReference reference) {
        return 2;
    }

    @Override
    protected String[] getMessageArgs(IReference reference) throws CoreException {
        IApiMember member = reference.getMember();
        if (member.getType() == 2) {
            ApiType ltype = (ApiType)member;
            String simpleTypeName = this.getSimpleTypeName(reference.getResolvedReference());
            if (ltype.isAnonymous()) {
                IApiType etype = ltype.getEnclosingType();
                String signature = Signatures.getQualifiedTypeSignature(etype);
                IApiMethod method = ltype.getEnclosingMethod();
                if (method != null) {
                    signature = Signatures.getQualifiedMethodSignature(method);
                }
                return new String[]{signature, simpleTypeName};
            }
            if (ltype.isLocal()) {
                IApiType etype = ltype.getEnclosingType();
                IApiMethod method = ltype.getEnclosingMethod();
                if (method != null) {
                    String methodsig = Signatures.getQualifiedMethodSignature(method);
                    return new String[]{Signatures.getAnonymousTypeName(ltype.getName()), methodsig, simpleTypeName};
                }
                return new String[]{Signatures.getAnonymousTypeName(ltype.getName()), this.getSimpleTypeName(etype), simpleTypeName};
            }
        }
        return new String[]{this.getSimpleTypeName(reference.getResolvedReference()), this.getSimpleTypeName(reference.getMember())};
    }

    @Override
    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        ApiType ltype;
        IApiMember member = reference.getMember();
        if (member.getType() == 2 && ((ltype = (ApiType)member).isLocal() || ltype.isAnonymous())) {
            return this.getMessageArgs(reference);
        }
        return new String[]{this.getQualifiedTypeName(reference.getResolvedReference()), this.getQualifiedTypeName(reference.getMember())};
    }

    @Override
    protected int getProblemFlags(IReference reference) {
        IApiMember member = reference.getMember();
        if (member.getType() == 2) {
            IApiType type = (IApiType)reference.getMember();
            if (type.isLocal()) {
                return 10;
            }
            if (type.isAnonymous()) {
                return 11;
            }
        }
        return 0;
    }
}

