/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.common.highlighting;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.jvmmodel.AnonymousClassUtil;
import org.eclipse.xtend.core.richstring.AbstractRichStringPartAcceptor;
import org.eclipse.xtend.core.richstring.DefaultIndentationHandler;
import org.eclipse.xtend.core.richstring.IRichStringIndentationHandler;
import org.eclipse.xtend.core.richstring.IRichStringPartAcceptor;
import org.eclipse.xtend.core.richstring.RichStringProcessor;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.CreateExtensionInfo;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.ide.common.highlighting.XtendHighlightingStyles;
import org.eclipse.xtend.lib.macro.Active;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.DeprecationUtil;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.ide.highlighting.XbaseHighlightingCalculator;

public class XtendHighlightingCalculator
extends XbaseHighlightingCalculator
implements XtendHighlightingStyles {
    @Inject
    private RichStringProcessor processor;
    @Inject
    private Provider<DefaultIndentationHandler> indentationHandlerProvider;
    private Set<Keyword> contextualKeywords;
    @Inject
    private XtendGrammarAccess xtendGrammarAccess;
    @Inject
    private AnonymousClassUtil anonymousClassUtil;

    @Inject
    protected void setXtendGrammarAccess(IGrammarAccess grammarAccess) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.collectKeywordsFromRule(grammarAccess, "ValidID", (ImmutableSet.Builder<Keyword>)builder);
        this.collectKeywordsFromRule(grammarAccess, "FeatureCallID", (ImmutableSet.Builder<Keyword>)builder);
        this.collectKeywordsFromRule(grammarAccess, "InnerVarID", (ImmutableSet.Builder<Keyword>)builder);
        this.contextualKeywords = builder.build();
    }

    protected TerminalRule getIDRule() {
        return this.xtendGrammarAccess.getIDRule();
    }

    protected void collectKeywordsFromRule(IGrammarAccess grammarAccess, String ruleName, ImmutableSet.Builder<Keyword> builder) {
        AbstractRule rule = GrammarUtil.findRuleForName((Grammar)grammarAccess.getGrammar(), (String)ruleName);
        if (!(rule instanceof TerminalRule)) {
            TreeIterator i = rule.eAllContents();
            while (i.hasNext()) {
                EObject o = (EObject)i.next();
                if (!(o instanceof Keyword)) continue;
                builder.add((Object)((Keyword)o));
            }
        }
    }

    protected boolean highlightElement(EObject object, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        if (object.eClass().getEPackage() == XtendPackage.eINSTANCE) {
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            switch (object.eClass().getClassifierID()) {
                case 1: {
                    if (((XtendClass)object).isAbstract()) {
                        this.highlightFeature(acceptor, object, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, new String[]{"xbase.abstract.class"});
                        break;
                    }
                    this.highlightFeature(acceptor, object, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, new String[]{"xbase.class"});
                    break;
                }
                case 17: {
                    this.highlightFeature(acceptor, object, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, new String[]{"xbase.enum"});
                    break;
                }
                case 16: {
                    this.highlightFeature(acceptor, object, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, new String[]{"xbase.interface"});
                    break;
                }
                case 15: {
                    this.highlightElement((XtendAnnotationType)object, acceptor, cancelIndicator);
                    break;
                }
                case 5: {
                    this.highlightElement((XtendField)object, acceptor, cancelIndicator);
                    break;
                }
                case 13: {
                    this.highlightElement((XtendConstructor)object, acceptor, cancelIndicator);
                    break;
                }
                case 4: {
                    this.highlightElement((XtendFunction)object, acceptor, cancelIndicator);
                    break;
                }
                case 6: {
                    if (SPECIAL_FEATURE_NAMES.contains(((XtendParameter)object).getName())) break;
                    this.highlightFeature(acceptor, object, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__NAME, new String[]{"xbase.parameter.variable"});
                    break;
                }
                default: {
                    return super.highlightElement(object, acceptor, cancelIndicator);
                }
            }
            this.highlightAnnotations(acceptor, (XtendAnnotationTarget)object);
            return false;
        }
        return super.highlightElement(object, acceptor, cancelIndicator);
    }

    protected void highlightElement(XtendAnnotationType xtendType, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        for (XAnnotation annotation : xtendType.getAnnotations()) {
            JvmType annotationType = annotation.getAnnotationType();
            if (annotationType == null || annotationType.eIsProxy() || !Active.class.getName().equals(annotationType.getIdentifier())) continue;
            this.highlightFeature(acceptor, (EObject)annotation, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, new String[]{"xtend.active.annotation"});
            break;
        }
    }

    protected void highlightElement(XtendField field, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        this.highlightFeature(acceptor, (EObject)field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, new String[]{"xbase.field"});
        if (field.isStatic()) {
            this.highlightFeature(acceptor, (EObject)field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, new String[]{"xbase.static.field"});
            if (field.isFinal()) {
                this.highlightFeature(acceptor, (EObject)field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, new String[]{"xbase.static.final.field"});
            }
        }
        XExpression initializer = field.getInitialValue();
        this.highlightRichStrings(initializer, acceptor);
    }

    protected void highlightElement(XtendConstructor function, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        XExpression rootExpression = function.getExpression();
        this.highlightRichStrings(rootExpression, acceptor);
    }

    protected void highlightElement(XtendFunction function, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        this.highlightFeature(acceptor, (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, new String[]{"xbase.method"});
        XExpression rootExpression = function.getExpression();
        this.highlightRichStrings(rootExpression, acceptor);
        CreateExtensionInfo createExtensionInfo = function.getCreateExtensionInfo();
        if (createExtensionInfo != null) {
            this.highlightRichStrings(createExtensionInfo.getCreateExpression(), acceptor);
        }
    }

    protected void highlightAnnotations(IHighlightedPositionAcceptor acceptor, XtendAnnotationTarget target) {
        if (target != null) {
            for (XAnnotation annotation : target.getAnnotations()) {
                this.highlightRichStrings((XExpression)annotation, acceptor);
                this.highlightDeprecatedXtendAnnotationTarget(acceptor, target, annotation);
            }
        }
    }

    protected void highlightAnnotation(XAnnotation annotation, IHighlightedPositionAcceptor acceptor) {
        JvmType annotationType = annotation.getAnnotationType();
        if (annotationType instanceof JvmAnnotationTarget) {
            for (JvmAnnotationReference annotationReference : ((JvmAnnotationTarget)annotationType).getAnnotations()) {
                JvmAnnotationType otherAnnotation = annotationReference.getAnnotation();
                if (otherAnnotation == null || otherAnnotation.eIsProxy() || !Active.class.getName().equals(otherAnnotation.getIdentifier())) continue;
                this.highlightAnnotation(annotation, acceptor, "xtend.active.annotation");
                return;
            }
        }
        super.highlightAnnotation(annotation, acceptor);
    }

    protected void highlightConstructorCall(XConstructorCall constructorCall, IHighlightedPositionAcceptor acceptor) {
        if (constructorCall.eContainer() instanceof AnonymousClass) {
            JvmGenericType superType = this.anonymousClassUtil.getSuperType((AnonymousClass)constructorCall.eContainer());
            if (superType != null) {
                this.highlightFeature(acceptor, (EObject)constructorCall, (EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, new String[]{this.getStyle(superType)});
            }
        } else {
            super.highlightConstructorCall(constructorCall, acceptor);
        }
    }

    protected void highlightDeprecatedXtendAnnotationTarget(IHighlightedPositionAcceptor acceptor, XtendAnnotationTarget target, XAnnotation annotation) {
        JvmType annotationType = annotation.getAnnotationType();
        if (annotationType instanceof JvmAnnotationType && DeprecationUtil.isDeprecatedAnnotation((JvmAnnotationType)((JvmAnnotationType)annotationType))) {
            if (target instanceof XtendConstructor) {
                ICompositeNode compositeNode = NodeModelUtils.getNode((EObject)target);
                for (ILeafNode leaf : compositeNode.getLeafNodes()) {
                    if (leaf.getGrammarElement() != this.xtendGrammarAccess.getMemberAccess().getNewKeyword_2_2_2()) continue;
                    this.highlightNode(acceptor, (INode)leaf, new String[]{"xbase.deprecated.members"});
                    this.highlightNode(acceptor, (INode)leaf, new String[]{"keyword"});
                    return;
                }
            } else {
                EStructuralFeature nameFeature = target.eClass().getEStructuralFeature("name");
                if (nameFeature != null) {
                    this.highlightFeature(acceptor, (EObject)target, nameFeature, new String[]{"xbase.deprecated.members"});
                }
            }
        }
    }

    protected void highlightRichStrings(XExpression expression, IHighlightedPositionAcceptor acceptor) {
        if (expression != null) {
            TreeIterator iterator = EcoreUtil2.eAll((EObject)expression);
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                if (!(object instanceof RichString)) continue;
                RichStringHighlighter highlighter = this.createRichStringHighlighter(acceptor);
                this.processor.process((RichString)object, (IRichStringPartAcceptor)highlighter, (IRichStringIndentationHandler)this.indentationHandlerProvider.get());
                iterator.prune();
            }
        }
    }

    protected RichStringHighlighter createRichStringHighlighter(IHighlightedPositionAcceptor acceptor) {
        return new RichStringHighlighter(acceptor);
    }

    protected void highlightSpecialIdentifiers(ILeafNode leafNode, IHighlightedPositionAcceptor acceptor, TerminalRule idRule) {
        super.highlightSpecialIdentifiers(leafNode, acceptor, idRule);
        if (this.contextualKeywords != null && this.contextualKeywords.contains(leafNode.getGrammarElement())) {
            ITextRegion leafRegion = leafNode.getTextRegion();
            acceptor.addPosition(leafRegion.getOffset(), leafRegion.getLength(), new String[]{"default"});
        }
    }

    protected class RichStringHighlighter
    extends AbstractRichStringPartAcceptor.ForLoopOnce {
        private int currentOffset = -1;
        private RichStringLiteral recent = null;
        private final IHighlightedPositionAcceptor acceptor;
        private Queue<ITextRegion> pendingRegions = Lists.newLinkedList();

        public RichStringHighlighter(IHighlightedPositionAcceptor acceptor) {
            this.acceptor = acceptor;
        }

        public void announceNextLiteral(RichStringLiteral object) {
            this.resetCurrentOffset(object);
        }

        public void acceptSemanticText(CharSequence text, RichStringLiteral origin) {
            this.resetCurrentOffset(origin);
            this.currentOffset += text.length();
        }

        protected void resetCurrentOffset(RichStringLiteral origin) {
            if (origin != null && origin != this.recent) {
                List featureNodes;
                INode recentNode = null;
                if (this.recent != null && this.currentOffset != -1 && (featureNodes = NodeModelUtils.findNodesForFeature((EObject)this.recent, (EStructuralFeature)XbasePackage.Literals.XSTRING_LITERAL__VALUE)).size() == 1) {
                    recentNode = (INode)featureNodes.get(0);
                    int closingQuoteLength = 0;
                    if (recentNode.getText().endsWith("'''")) {
                        closingQuoteLength = 3;
                    } else if (recentNode.getText().endsWith("''")) {
                        closingQuoteLength = 2;
                    } else if (recentNode.getText().endsWith("'") || recentNode.getText().endsWith("\u00ab")) {
                        closingQuoteLength = 1;
                    }
                    int expectedOffset = recentNode.getTotalEndOffset() - closingQuoteLength;
                    if (expectedOffset != this.currentOffset) {
                        this.pendingRegions.add((ITextRegion)new TextRegion(this.currentOffset, Math.max(0, expectedOffset - this.currentOffset)));
                    }
                }
                if ((featureNodes = NodeModelUtils.findNodesForFeature((EObject)origin, (EStructuralFeature)XbasePackage.Literals.XSTRING_LITERAL__VALUE)).size() == 1) {
                    INode node = (INode)featureNodes.get(0);
                    this.currentOffset = node.getOffset();
                    if (node.getText().charAt(0) == '\'') {
                        this.acceptor.addPosition(this.currentOffset, 3, new String[]{"xtend.insignificant.template.text"});
                        this.highlightClosingQuotes(node);
                        this.currentOffset += 3;
                    } else if (node.getText().startsWith("\u00ab\u00ab")) {
                        int lineFeed;
                        String nodeText = node.getText();
                        int length = lineFeed = nodeText.indexOf(10);
                        int carriageReturn = nodeText.indexOf(13);
                        if (carriageReturn != -1) {
                            length = length == -1 ? carriageReturn : Math.min(carriageReturn, length);
                        }
                        int start = node.getTotalOffset();
                        if (length == -1) {
                            length = node.getTotalLength();
                        }
                        if (recentNode != null && recentNode.getTotalEndOffset() == start) {
                            --start;
                            ++length;
                        }
                        this.acceptor.addPosition(start, length, new String[]{"comment"});
                        this.highlightClosingQuotes(node);
                        this.currentOffset = start + length + 1;
                        if (lineFeed == carriageReturn + 1) {
                            ++this.currentOffset;
                        }
                    } else {
                        this.highlightClosingQuotes(node);
                        ++this.currentOffset;
                    }
                }
                this.recent = origin;
            }
        }

        protected void highlightClosingQuotes(INode node) {
            int length = 0;
            if (node.getText().endsWith("'''")) {
                length = 3;
            } else if (node.getText().endsWith("''")) {
                length = 2;
            } else if (node.getText().endsWith("'")) {
                length = 1;
            }
            if (length != 0) {
                this.acceptor.addPosition(this.currentOffset + node.getLength() - length, length, new String[]{"xtend.insignificant.template.text"});
            }
        }

        public void acceptTemplateText(CharSequence text, RichStringLiteral origin) {
            this.resetCurrentOffset(origin);
            if (text.length() > 0) {
                int length = text.length();
                while (!this.pendingRegions.isEmpty()) {
                    ITextRegion pending = this.pendingRegions.poll();
                    length -= pending.getLength();
                    this.acceptor.addPosition(pending.getOffset(), pending.getLength(), new String[]{"xtend.insignificant.template.text"});
                }
                if (length != 0) {
                    this.acceptor.addPosition(this.currentOffset, length, new String[]{"xtend.insignificant.template.text"});
                    this.currentOffset += length;
                }
            }
        }

        public void acceptSemanticLineBreak(int charCount, RichStringLiteral origin, boolean controlStructureSeen) {
            this.resetCurrentOffset(origin);
            if (controlStructureSeen) {
                this.acceptor.addPosition(this.currentOffset, charCount, new String[]{"xtend.potential.line.break"});
            } else {
                this.acceptor.addPosition(this.currentOffset, charCount, new String[]{"xtend.template.line.break"});
            }
            this.currentOffset += charCount;
        }

        public void acceptTemplateLineBreak(int charCount, RichStringLiteral origin) {
            this.resetCurrentOffset(origin);
            this.acceptor.addPosition(this.currentOffset, charCount, new String[]{"xtend.insignificant.template.text"});
            this.currentOffset += charCount;
        }

        public void acceptIfCondition(XExpression condition) {
            XtendHighlightingCalculator.this.highlightRichStrings(condition, this.acceptor);
        }

        public void acceptElseIfCondition(XExpression condition) {
            XtendHighlightingCalculator.this.highlightRichStrings(condition, this.acceptor);
        }

        public void acceptForLoop(JvmFormalParameter parameter, XExpression expression) {
            XtendHighlightingCalculator.this.highlightRichStrings(expression, this.acceptor);
            super.acceptForLoop(parameter, expression);
        }

        public void acceptExpression(XExpression expression, CharSequence indentation) {
            XtendHighlightingCalculator.this.highlightRichStrings(expression, this.acceptor);
        }
    }
}

