/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class RemoveAnnotationProposal
implements IJavaCompletionProposal {
    private final IInvocationContext fContext;
    private final MethodDeclaration fMethodDecl;
    private final String fAnnotationQualifiedName;

    public RemoveAnnotationProposal(IInvocationContext context, MethodDeclaration methodDecl, String annotationQualifiedName) {
        this.fContext = context;
        this.fMethodDecl = methodDecl;
        this.fAnnotationQualifiedName = annotationQualifiedName;
    }

    public void apply(IDocument document) {
        try {
            TextEdit rewriteEdit;
            CompilationUnit astRoot = this.fContext.getASTRoot();
            ICompilationUnit cu = this.fContext.getCompilationUnit();
            AST ast = astRoot.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            IMethodBinding methodBinding = this.fMethodDecl.resolveBinding();
            if (methodBinding != null) {
                IAnnotationBinding[] annotations;
                IAnnotationBinding[] iAnnotationBindingArray = annotations = methodBinding.getAnnotations();
                int n = annotations.length;
                int n2 = 0;
                block2: while (n2 < n) {
                    IAnnotationBinding annotationBinding = iAnnotationBindingArray[n2];
                    ITypeBinding annotationType = annotationBinding.getAnnotationType();
                    if (annotationType != null && this.fAnnotationQualifiedName.equals(annotationType.getQualifiedName())) {
                        List modifiers = this.fMethodDecl.modifiers();
                        for (Object modifier : modifiers) {
                            Annotation annotation;
                            if (!(modifier instanceof Annotation) || (annotation = (Annotation)modifier).resolveAnnotationBinding() != annotationBinding) continue;
                            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)this.fMethodDecl, MethodDeclaration.MODIFIERS2_PROPERTY);
                            listRewrite.remove((ASTNode)annotation, null);
                            break block2;
                        }
                        break;
                    }
                    ++n2;
                }
            }
            ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
            importRewrite.removeImport(this.fAnnotationQualifiedName);
            MultiTextEdit multiEdit = new MultiTextEdit();
            TextEdit importEdit = importRewrite.rewriteImports(null);
            if (importEdit.hasChildren() || importEdit.getLength() != 0) {
                multiEdit.addChild(importEdit);
            }
            if ((rewriteEdit = rewrite.rewriteAST(document, cu.getOptions(true))).hasChildren() || rewriteEdit.getLength() != 0) {
                multiEdit.addChild(rewriteEdit);
            }
            if (multiEdit.hasChildren()) {
                multiEdit.apply(document);
            }
        }
        catch (CoreException | BadLocationException e) {
            JUnitPlugin.log(e);
        }
    }

    public String getAdditionalProposalInfo() {
        String simpleName = this.fAnnotationQualifiedName.substring(this.fAnnotationQualifiedName.lastIndexOf(46) + 1);
        return MessageFormat.format(JUnitMessages.JUnitQuickAssistProcessor_remove_annotation_info, simpleName);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        String simpleName = this.fAnnotationQualifiedName.substring(this.fAnnotationQualifiedName.lastIndexOf(46) + 1);
        return MessageFormat.format(JUnitMessages.JUnitQuickAssistProcessor_remove_annotation_description, simpleName);
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.annotation_obj.gif");
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public int getRelevance() {
        return 10;
    }
}

