/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.viewers.FindElementDialog;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.TimeTriggeredProgressMonitorDialog;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualItem;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualTree;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualTreeModelViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class VirtualFindAction
extends Action
implements IUpdate {
    private final TreeModelViewer fClientViewer;

    public VirtualFindAction(TreeModelViewer viewer) {
        this.fClientViewer = viewer;
        this.setText(ActionMessages.FindAction_0);
        this.setId(DebugUIPlugin.getUniqueIdentifier() + ".FindElementAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.find_element_context");
        this.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
    }

    private VirtualTreeModelViewer initVirtualViewer(TreeModelViewer clientViewer, VirtualViewerListener listener) {
        Object input = clientViewer.getInput();
        ModelDelta stateDelta = new ModelDelta(input, 0);
        clientViewer.saveElementState(TreePath.EMPTY, stateDelta, 0x100000);
        listener.fRemainingUpdatesCount = this.calcUpdatesCount(stateDelta);
        VirtualTreeModelViewer fVirtualViewer = new VirtualTreeModelViewer(clientViewer.getDisplay(), 0, clientViewer.getPresentationContext());
        fVirtualViewer.setFilters(clientViewer.getFilters());
        fVirtualViewer.addViewerUpdateListener(listener);
        fVirtualViewer.addLabelUpdateListener(listener);
        String[] columns = clientViewer.getPresentationContext().getColumns();
        fVirtualViewer.setInput(input);
        if (fVirtualViewer.canToggleColumns()) {
            fVirtualViewer.setShowColumns(clientViewer.isShowColumns());
            fVirtualViewer.setVisibleColumns(columns);
        }
        fVirtualViewer.updateViewer(stateDelta);
        return fVirtualViewer;
    }

    public void run() {
        VirtualViewerListener listener = new VirtualViewerListener();
        VirtualTreeModelViewer virtualViewer = this.initVirtualViewer(this.fClientViewer, listener);
        TimeTriggeredProgressMonitorDialog dialog = new TimeTriggeredProgressMonitorDialog(this.fClientViewer.getControl().getShell(), 500);
        IProgressMonitor monitor = dialog.getProgressMonitor();
        dialog.setCancelable(true);
        try {
            dialog.run(true, true, arg_0 -> this.lambda$0(listener, arg_0));
        }
        catch (InvocationTargetException e) {
            DebugUIPlugin.log(e);
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        VirtualTree root = virtualViewer.getTree();
        if (!monitor.isCanceled()) {
            ArrayList<VirtualItem> list = new ArrayList<VirtualItem>();
            this.collectAllChildren(root, list);
            FindLabelProvider labelProvider = new FindLabelProvider(virtualViewer, list);
            VirtualItem result = this.performFind(list, labelProvider);
            if (result != null) {
                this.setSelectionToClient(virtualViewer, (ILabelProvider)labelProvider, result);
            }
        }
        virtualViewer.removeLabelUpdateListener(listener);
        virtualViewer.removeViewerUpdateListener(listener);
        virtualViewer.dispose();
    }

    private int calcUpdatesCount(IModelDelta stateDelta) {
        int[] count = new int[1];
        stateDelta.accept((delta, depth) -> {
            if ((delta.getFlags() & 0x100000) != 0) {
                nArray[0] = count[0] + delta.getChildCount();
                return true;
            }
            return false;
        });
        return count[0] * 2;
    }

    private void collectAllChildren(VirtualItem element, List<VirtualItem> collect) {
        VirtualItem[] children = element.getItems();
        if (children != null) {
            VirtualItem[] virtualItemArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                VirtualItem child = virtualItemArray[n2];
                if (!child.needsLabelUpdate()) {
                    collect.add(child);
                    this.collectAllChildren(child, collect);
                }
                ++n2;
            }
        }
    }

    protected VirtualItem performFind(List<VirtualItem> items, FindLabelProvider labelProvider) {
        Object[] elements;
        FindElementDialog dialog = new FindElementDialog(this.fClientViewer.getControl().getShell(), (ILabelProvider)labelProvider, items.toArray());
        dialog.setTitle(ActionMessages.FindDialog_3);
        dialog.setMessage(ActionMessages.FindDialog_1);
        if (dialog.open() == 0 && (elements = dialog.getResult()).length == 1) {
            return (VirtualItem)elements[0];
        }
        return null;
    }

    protected void setSelectionToClient(VirtualTreeModelViewer virtualViewer, ILabelProvider labelProvider, VirtualItem findItem) {
        virtualViewer.getTree().setSelection(new VirtualItem[]{findItem});
        ModelDelta stateDelta = new ModelDelta(virtualViewer.getInput(), 0);
        virtualViewer.saveElementState(TreePath.EMPTY, stateDelta, 0x200000);
        stateDelta.accept((delta, depth) -> {
            if ((delta.getFlags() & 0x200000) != 0) {
                ((ModelDelta)delta).setFlags(delta.getFlags() | 0x4000000);
            }
            return true;
        });
        this.fClientViewer.updateViewer(stateDelta);
        ISelection selection = this.fClientViewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection) || !((IStructuredSelection)selection).getFirstElement().equals(findItem.getData())) {
            DebugUIPlugin.errorDialog(this.fClientViewer.getControl().getShell(), ActionMessages.VirtualFindAction_0, MessageFormat.format(ActionMessages.VirtualFindAction_1, labelProvider.getText((Object)findItem)), (IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), ActionMessages.VirtualFindAction_1));
        }
    }

    public void update() {
        this.setEnabled(this.fClientViewer.getInput() != null && this.fClientViewer.getChildCount(TreePath.EMPTY) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$0(VirtualViewerListener var1_1, IProgressMonitor m) throws InvocationTargetException, InterruptedException {
        var3_3 = var1_1;
        synchronized (var3_3) {
            var1_1.fProgressMonitor = m;
            var1_1.fProgressMonitor.beginTask(DebugUIPlugin.removeAccelerators(this.getText()), var1_1.fRemainingUpdatesCount);
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var3_3
            if (true) ** GOTO lbl12
        }
        do {
            Thread.sleep(1L);
lbl12:
            // 2 sources

        } while ((!var1_1.fLabelUpdatesComplete || !var1_1.fViewerUpdatesComplete) && !var1_1.fProgressMonitor.isCanceled());
        var3_3 = var1_1;
        synchronized (var3_3) {
            var1_1.fProgressMonitor = null;
        }
    }

    private static class FindLabelProvider
    extends LabelProvider {
        private final VirtualTreeModelViewer fVirtualViewer;
        private final Map<VirtualItem, String> fTextCache = new HashMap<VirtualItem, String>();

        public FindLabelProvider(VirtualTreeModelViewer viewer, List<VirtualItem> items) {
            this.fVirtualViewer = viewer;
            for (VirtualItem item : items) {
                this.fTextCache.put(item, this.fVirtualViewer.getText(item, 0));
            }
        }

        public Image getImage(Object element) {
            return this.fVirtualViewer.getImage((VirtualItem)element, 0);
        }

        public String getText(Object element) {
            return this.fTextCache.get(element);
        }
    }

    private static class VirtualViewerListener
    implements IViewerUpdateListener,
    ILabelUpdateListener {
        private boolean fViewerUpdatesComplete = false;
        private boolean fLabelUpdatesComplete = false;
        private IProgressMonitor fProgressMonitor;
        private int fRemainingUpdatesCount = 0;

        private VirtualViewerListener() {
        }

        @Override
        public void labelUpdateStarted(ILabelUpdate update) {
        }

        @Override
        public void labelUpdateComplete(ILabelUpdate update) {
            this.incrementProgress(1);
        }

        @Override
        public void labelUpdatesBegin() {
            this.fLabelUpdatesComplete = false;
        }

        @Override
        public void labelUpdatesComplete() {
            this.fLabelUpdatesComplete = true;
            this.completeProgress();
        }

        @Override
        public void updateStarted(IViewerUpdate update) {
        }

        @Override
        public void updateComplete(IViewerUpdate update) {
            if (update instanceof IChildrenUpdate) {
                this.incrementProgress(((IChildrenUpdate)update).getLength());
            }
        }

        @Override
        public void viewerUpdatesBegin() {
            this.fViewerUpdatesComplete = false;
        }

        @Override
        public void viewerUpdatesComplete() {
            this.fViewerUpdatesComplete = true;
            this.completeProgress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeProgress() {
            IProgressMonitor pm;
            VirtualViewerListener virtualViewerListener = this;
            synchronized (virtualViewerListener) {
                pm = this.fProgressMonitor;
            }
            if (pm != null && this.fLabelUpdatesComplete && this.fViewerUpdatesComplete) {
                pm.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void incrementProgress(int count) {
            IProgressMonitor pm;
            VirtualViewerListener virtualViewerListener = this;
            synchronized (virtualViewerListener) {
                pm = this.fProgressMonitor;
                this.fRemainingUpdatesCount -= count;
            }
            if (pm != null && this.fLabelUpdatesComplete && this.fViewerUpdatesComplete) {
                pm.worked(count);
            }
        }
    }
}

