/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.util;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class GenModelUtil {
    public static String getAnnotation(GenBase genBase, String sourceURI, String key) {
        GenAnnotation genAnnotation = genBase.getGenAnnotation(sourceURI);
        return genAnnotation == null ? null : (String)genAnnotation.getDetails().get((Object)key);
    }

    public static void setAnnotation(GenBase genBase, String sourceURI, String key, String value) {
        GenAnnotation genAnnotation = genBase.getGenAnnotation(sourceURI);
        if (genAnnotation == null) {
            genAnnotation = GenModelFactory.eINSTANCE.createGenAnnotation();
            genAnnotation.setSource(sourceURI);
            genBase.getGenAnnotations().add((Object)genAnnotation);
        }
        genAnnotation.getDetails().put((Object)key, (Object)value);
    }

    private static IJavaProject getJavaProject(GenModel genModel) {
        String modelDirectory = genModel.getModelDirectory();
        try {
            URI uri = URI.createURI((String)modelDirectory);
            IJavaProject javaProject = GenModelUtil.getJavaProject(uri);
            if (javaProject != null) {
                return javaProject;
            }
        }
        catch (Throwable uri) {
            // empty catch block
        }
        Resource resource = genModel.eResource();
        if (resource != null) {
            return GenModelUtil.getJavaProject(resource.getURI());
        }
        return null;
    }

    private static IJavaProject getJavaProject(URI uri) {
        IWorkspaceRoot workspaceRoot;
        String projectName = null;
        if (uri != null) {
            if (uri.isPlatformResource()) {
                projectName = uri.segment(1);
            } else if (uri.isHierarchical() && uri.segmentCount() > 1) {
                projectName = uri.segment(0);
            }
        }
        if (projectName != null && (workspaceRoot = EcorePlugin.getWorkspaceRoot()) != null) {
            IProject project = workspaceRoot.getProject(projectName);
            try {
                if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return JavaCore.create((IProject)project);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Map<String, String> getJavaOptions(GenModel genModel) {
        IJavaProject javaProject = GenModelUtil.getJavaProject(genModel);
        Hashtable options = javaProject != null ? javaProject.getOptions(true) : JavaCore.getOptions();
        return options;
    }

    public static Generator createGenerator(GenModel genModel) {
        Generator generator = new Generator();
        generator.setInput(genModel);
        return generator;
    }

    public static boolean hasAPIDeprecatedTag(Collection<?> ... elements) {
        Collection<?>[] collectionArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<?> genBaseElements = collectionArray[n2];
            for (Object genBase : genBaseElements) {
                if (!(genBase instanceof GenBase) || !((GenBase)genBase).hasAPIDeprecatedTag()) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasImplicitAPIDeprecatedTag(Collection<?> ... elements) {
        Collection<?>[] collectionArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<?> genBaseElements = collectionArray[n2];
            for (Object genBase : genBaseElements) {
                if (!(genBase instanceof GenBase) || !((GenBase)genBase).hasImplicitAPIDeprecatedTag()) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static GenModel getGenModel(Resource resource) {
        return (GenModel)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)GenModelPackage.Literals.GEN_MODEL);
    }
}

