/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.jdt.editor.document;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swtbot.generator.framework.AnnotationRule;
import org.eclipse.swtbot.generator.framework.GenerationRule;

public class Method {
    private List<GenerationRule> code;
    private String name;
    private boolean active;
    private List<AnnotationRule> annotations;

    public Method(String name) {
        this.name = name;
        this.code = new ArrayList<GenerationRule>();
        this.active = true;
        this.annotations = new ArrayList<AnnotationRule>();
    }

    public void addCode(GenerationRule rule) {
        this.code.add(rule);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<GenerationRule> getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public List<AnnotationRule> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(AnnotationRule annotation) {
        this.annotations.add(annotation);
    }

    public boolean removeAnnotation(AnnotationRule annotation) {
        return this.annotations.remove(annotation);
    }

    public int getAllLinesSize() {
        int methodsCodeSize = 0;
        for (GenerationRule gr : this.code) {
            methodsCodeSize += gr.getActions().size();
        }
        return methodsCodeSize;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Method other = (Method)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

