/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.widgets.timegraph.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.ui.widgets.timegraph.model.TimeLineEvent;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class TimeGraphLineEntry
extends TimeGraphEntry {
    public TimeGraphLineEntry(String name, long startTime, long endTime) {
        super(name, startTime, endTime);
    }

    public TimeGraphLineEntry(@NonNull TimeGraphEntryModel model) {
        super(model);
    }

    @Override
    public void addEvent(ITimeEvent event) {
        if (TimeGraphLineEntry.isValidEvent(event)) {
            super.addEvent(event);
        }
    }

    @Override
    public void addZoomedEvent(ITimeEvent event) {
        if (TimeGraphLineEntry.isValidEvent(event)) {
            super.addZoomedEvent(event);
        }
    }

    @Override
    public void setEventList(List<ITimeEvent> eventList) {
        TimeGraphLineEntry.sanitizeList(eventList, list -> super.setEventList((List<ITimeEvent>)list));
    }

    @Override
    public void updateZoomedEvent(ITimeEvent event) {
        if (TimeGraphLineEntry.isValidEvent(event)) {
            super.updateZoomedEvent(event);
        }
    }

    @Override
    public void setZoomedEventList(List<ITimeEvent> eventList) {
        TimeGraphLineEntry.sanitizeList(eventList, list -> super.setZoomedEventList((List<ITimeEvent>)list));
    }

    @Override
    public ITimeGraphEntry.DisplayStyle getStyle() {
        return ITimeGraphEntry.DisplayStyle.LINE;
    }

    private static boolean isValidEvent(ITimeEvent event) {
        return event instanceof TimeLineEvent;
    }

    private static void sanitizeList(List<ITimeEvent> sourceList, Consumer<List<ITimeEvent>> listConsumer) {
        if (sourceList != null) {
            ArrayList<ITimeEvent> events = new ArrayList<ITimeEvent>();
            for (ITimeEvent event : sourceList) {
                if (!TimeGraphLineEntry.isValidEvent(event)) continue;
                events.add(event);
            }
            listConsumer.accept(events);
        } else {
            listConsumer.accept(null);
        }
    }
}

