/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.extension.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.eclipse.cdt.core.cdtvariables.ICdtVariablesContributor;
import org.eclipse.cdt.core.settings.model.CConfigurationStatus;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.extension.CTargetPlatformData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDataFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CDefaultConfigurationData
extends CConfigurationData {
    protected String fDescription;
    private HashMap<IPath, CResourceData> fResourceDataMap = new HashMap();
    protected CFolderData fRootFolderData;
    protected String fName;
    protected String fId;
    protected CTargetPlatformData fTargetPlatformData;
    protected CBuildData fBuildData;
    protected ICSourceEntry[] fSourceEntries;
    private CDataFactory fFactory;
    protected boolean fIsModified;
    private CConfigurationStatus fStatus = CConfigurationStatus.CFG_STATUS_OK;

    protected CDefaultConfigurationData(CDataFactory factory) {
        if (factory == null) {
            factory = new CDataFactory();
        }
        this.fFactory = factory;
    }

    public CDataFactory getFactory() {
        return this.fFactory;
    }

    public CDefaultConfigurationData(String id, String name, CDataFactory factory) {
        this.fId = id;
        this.fName = name;
        if (factory == null) {
            factory = new CDataFactory();
        }
        this.fFactory = factory;
    }

    public CDefaultConfigurationData(String id, String name, CConfigurationData base, CDataFactory facroty, boolean clone) {
        this(id, name, facroty);
        this.copySettingsFrom(base, clone);
    }

    protected IPath standardizePath(IPath path) {
        return path.makeRelative().setDevice(null);
    }

    protected void addRcData(CResourceData data) {
        IPath path = this.standardizePath(data.getPath());
        if (path.segmentCount() == 0) {
            if (data.getType() == 4) {
                this.fRootFolderData = (CFolderData)data;
            } else {
                return;
            }
        }
        this.fResourceDataMap.put(path, data);
    }

    protected void removeRcData(IPath path) {
        path = this.standardizePath(path);
        this.fResourceDataMap.remove(path);
        if (path.segmentCount() == 0) {
            this.fRootFolderData = null;
        }
    }

    protected void copySettingsFrom(CConfigurationData base, boolean clone) {
        if (base == null) {
            return;
        }
        this.fDescription = base.getDescription();
        this.fTargetPlatformData = this.copyTargetPlatformData(base.getTargetPlatformData(), clone);
        this.fSourceEntries = base.getSourceEntries();
        this.fBuildData = this.copyBuildData(base.getBuildData(), clone);
        this.fStatus = base.getStatus();
        if (this.fStatus == null) {
            this.fStatus = CConfigurationStatus.CFG_STATUS_OK;
        }
        CFolderData baseRootFolderData = base.getRootFolderData();
        this.fRootFolderData = this.copyFolderData(baseRootFolderData.getPath(), baseRootFolderData, clone);
        this.addRcData(this.fRootFolderData);
        CResourceData[] rcDatas = this.filterRcDatasToCopy(base);
        int i = 0;
        while (i < rcDatas.length) {
            CResourceData rcData = rcDatas[i];
            if (baseRootFolderData != rcData) {
                if (rcData instanceof CFolderData) {
                    this.addRcData(this.copyFolderData(rcData.getPath(), (CFolderData)rcData, clone));
                } else if (rcData instanceof CFileData) {
                    this.addRcData(this.copyFileData(rcData.getPath(), (CFileData)rcData, clone));
                }
            }
            ++i;
        }
    }

    protected CResourceData[] filterRcDatasToCopy(CConfigurationData base) {
        return base.getResourceDatas();
    }

    protected CFolderData copyFolderData(IPath path, CFolderData base, boolean clone) {
        return this.fFactory.createFolderData(this, base, null, clone, path);
    }

    protected CFileData copyFileData(IPath path, CFileData base, boolean clone) {
        return this.fFactory.createFileData(this, base, null, null, clone, path);
    }

    protected CFileData copyFileData(IPath path, CFolderData base, CLanguageData langData) {
        return this.fFactory.createFileData(this, base, langData, null, false, path);
    }

    protected CTargetPlatformData copyTargetPlatformData(CTargetPlatformData base, boolean clone) {
        return this.fFactory.createTargetPlatformData(this, base, null, base != null ? base.getName() : null, clone);
    }

    protected CBuildData copyBuildData(CBuildData data, boolean clone) {
        return this.fFactory.createBuildData(this, data, null, data != null ? data.getName() : null, clone);
    }

    @Override
    public CFolderData createFolderData(IPath path, CFolderData base) throws CoreException {
        CFolderData data = this.copyFolderData(path, base, false);
        this.addRcData(data);
        this.setModified(true);
        return data;
    }

    @Override
    public CFileData createFileData(IPath path, CFileData base) throws CoreException {
        CFileData data = this.copyFileData(path, base, false);
        this.addRcData(data);
        this.setModified(true);
        return data;
    }

    @Override
    public CFileData createFileData(IPath path, CFolderData base, CLanguageData langData) throws CoreException {
        CFileData data = this.copyFileData(path, base, langData);
        this.addRcData(data);
        this.setModified(true);
        return data;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public void setDescription(String description) {
        if (Objects.equals(description, this.fDescription)) {
            return;
        }
        this.fDescription = description;
        this.setModified(true);
    }

    @Override
    public CResourceData[] getResourceDatas() {
        return this.fResourceDataMap.values().toArray(new CResourceData[this.fResourceDataMap.size()]);
    }

    @Override
    public CFolderData getRootFolderData() {
        return this.fRootFolderData;
    }

    public CFolderData createRootFolderData() throws CoreException {
        if (this.fRootFolderData == null) {
            this.createFolderData((IPath)new Path(""), null);
        }
        return this.fRootFolderData;
    }

    @Override
    public void removeResourceData(CResourceData data) throws CoreException {
        if (data == this.getResourceData(data.getPath())) {
            IPath path = this.standardizePath(data.getPath());
            this.removeRcData(path);
            this.setModified(true);
        }
    }

    public CResourceData getResourceData(IPath path) {
        path = this.standardizePath(path);
        return this.fResourceDataMap.get(path);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        if (Objects.equals(name, this.fName)) {
            return;
        }
        this.fName = name;
        this.setModified(true);
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public boolean isValid() {
        return this.getId() != null;
    }

    @Override
    public CTargetPlatformData getTargetPlatformData() {
        return this.fTargetPlatformData;
    }

    @Override
    public ICSourceEntry[] getSourceEntries() {
        return this.fSourceEntries != null ? (ICSourceEntry[])this.fSourceEntries.clone() : null;
    }

    @Override
    public void setSourceEntries(ICSourceEntry[] entries) {
        if (Arrays.equals(entries, this.fSourceEntries)) {
            return;
        }
        this.fSourceEntries = entries != null ? (ICSourceEntry[])entries.clone() : null;
        this.setModified(true);
    }

    @Override
    public CBuildData getBuildData() {
        return this.fBuildData;
    }

    public void initEmptyData() throws CoreException {
        if (this.getRootFolderData() == null) {
            this.createRootFolderData();
        }
        if (this.getTargetPlatformData() == null) {
            this.createTargetPlatformData();
        }
        if (this.getBuildData() == null) {
            this.createBuildData();
        }
    }

    public CTargetPlatformData createTargetPlatformData() {
        this.fTargetPlatformData = this.copyTargetPlatformData(null, false);
        this.setModified(true);
        return this.fTargetPlatformData;
    }

    public CBuildData createBuildData() {
        this.fBuildData = this.copyBuildData(null, false);
        this.setModified(true);
        return this.fBuildData;
    }

    @Override
    public ICdtVariablesContributor getBuildVariablesContributor() {
        return null;
    }

    public boolean isModified() {
        if (this.fIsModified) {
            return true;
        }
        CResourceData[] rcDatas = this.getResourceDatas();
        int i = 0;
        while (i < rcDatas.length) {
            if (this.fFactory.isModified(rcDatas[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setModified(boolean modified) {
        this.fIsModified = modified;
        if (!modified) {
            CResourceData[] rcDatas = this.getResourceDatas();
            int i = 0;
            while (i < rcDatas.length) {
                this.fFactory.setModified(rcDatas[i], false);
                ++i;
            }
        }
    }

    @Override
    public CConfigurationStatus getStatus() {
        return this.fStatus;
    }
}

