/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.commands;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.wikitext.ui.util.IOUtil;
import org.eclipse.mylyn.wikitext.parser.util.MarkupToEclipseToc;
import org.eclipse.mylyn.wikitext.ui.commands.ConvertMarkupToHtml;
import org.eclipse.mylyn.wikitext.ui.commands.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConvertMarkupToEclipseHelp
extends ConvertMarkupToHtml {
    @Override
    protected void handleFile(IFile file, String name) {
        super.handleFile(file, name);
        IFile newFile = file.getParent().getFile((IPath)new Path(name + "-toc.xml"));
        if (newFile.exists() && !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ConvertMarkupToEclipseHelp_overwrite, (String)NLS.bind((String)Messages.ConvertMarkupToEclipseHelp_fileExistsOverwrite, (Object[])new Object[]{newFile.getFullPath()}))) {
            return;
        }
        IPath parentFullPath = file.getParent().getFullPath();
        IPath pluginPathToHelp = parentFullPath.removeFirstSegments(1);
        MarkupToEclipseToc markupToEclipseToc = new MarkupToEclipseToc();
        markupToEclipseToc.setMarkupLanguage(this.markupLanguage);
        markupToEclipseToc.setBookTitle(name);
        String htmlFilePath = name + ".html";
        if (pluginPathToHelp.segmentCount() > 0) {
            Object pathPart = pluginPathToHelp.toString();
            if (!((String)pathPart).endsWith("/")) {
                pathPart = (String)pathPart + "/";
            }
            htmlFilePath = (String)pathPart + htmlFilePath;
        }
        markupToEclipseToc.setHtmlFile(htmlFilePath);
        try {
            IRunnableWithProgress runnable = monitor -> {
                try {
                    String content = IOUtil.readFully(file);
                    String tocXml = markupToEclipseToc.parse(content);
                    if (newFile.exists()) {
                        newFile.setContents((InputStream)new ByteArrayInputStream(tocXml.getBytes(StandardCharsets.UTF_8)), false, true, monitor);
                    } else {
                        newFile.create((InputStream)new ByteArrayInputStream(tocXml.getBytes(StandardCharsets.UTF_8)), false, monitor);
                    }
                    newFile.setCharset("utf-8", monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            StringWriter message = new StringWriter();
            Throwable throwable = null;
            Object var11_15 = null;
            try (PrintWriter out = new PrintWriter(message);){
                out.println(Messages.ConvertMarkupToEclipseHelp_cannotConvert + e.getMessage());
                out.println(Messages.ConvertMarkupToEclipseHelp_detailsFollow);
                e.printStackTrace(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ConvertMarkupToEclipseHelp_cannotCompleteOperation, (String)message.toString());
        }
    }
}

