/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.Arrays;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.text.build.Build;
import org.eclipse.pde.internal.core.text.build.BuildEntry;
import org.eclipse.pde.internal.core.text.build.BuildModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.BuildEntryMarkerResolution;

public class AddBuildEntrySrcExcludesResolution
extends BuildEntryMarkerResolution {
    public AddBuildEntrySrcExcludesResolution(int type, IMarker marker, String entry, String value) {
        super(type, marker);
        this.fEntry = entry;
        this.fToken = value;
    }

    public String getLabel() {
        return NLS.bind((String)PDEUIMessages.AddBuildEntryResolution_add, (Object)this.fToken, (Object)this.fEntry);
    }

    @Override
    protected void createChange(Build build) {
        try {
            this.fToken = (String)this.marker.getAttribute("buildEntry.tokenValue");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            BuildEntry buildEntry;
            BuildModel buildModel = build.getModel();
            if (buildModel.isStale()) {
                buildModel.reconciled(buildModel.getDocument());
            }
            if ((buildEntry = (BuildEntry)build.getEntry(this.fEntry)) == null) {
                buildEntry = new BuildEntry(this.fEntry, (IBuildModel)buildModel);
            }
            if (this.fToken != null) {
                buildEntry.addToken(this.fToken);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @Override
    public void run(IMarker marker) {
        super.run(marker);
        this.marker = marker;
    }

    @Override
    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return (IMarker[])Arrays.stream(markers).filter(m -> !m.equals((Object)this.marker)).filter(m -> "compilers.p.build.source.library".equals(m.getAttribute("compilerKey", ""))).toArray(IMarker[]::new);
    }
}

