/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd.participants;

import java.util.List;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.DTDEntityDecl;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentLink;
import org.w3c.dom.NamedNodeMap;

public class DTDDocumentLinkParticipant
implements IDocumentLinkParticipant {
    private final URIResolverExtensionManager resolverManager;

    public DTDDocumentLinkParticipant(URIResolverExtensionManager resolverManager) {
        this.resolverManager = resolverManager;
    }

    @Override
    public void findDocumentLinks(DOMDocument document, List<DocumentLink> links) {
        DOMDocumentType docType = document.getDoctype();
        if (docType != null) {
            NamedNodeMap entities = docType.getEntities();
            for (int i = 0; i < entities.getLength(); ++i) {
                DTDEntityDecl entity = (DTDEntityDecl)entities.item(i);
                String location = this.resolverManager.resolve(document.getDocumentURI(), entity.getPublicId(), entity.getSystemId());
                if (location == null) continue;
                try {
                    DTDDeclParameter systemIdRange = entity.getSystemIdNode();
                    if (systemIdRange == null) continue;
                    links.add(XMLPositionUtility.createDocumentLink(systemIdRange, location, true));
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }
}

