/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.E4Properties;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.E4XMIResourceFactory;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;

public class XMIModelResource
implements IModelResource {
    private final EditingDomain editingDomain;
    private final Resource resource;
    private final List<IModelResource.ModelListener> listeners = new ArrayList<IModelResource.ModelListener>();
    private IObservableList<EObject> list;

    public XMIModelResource(URI uri) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(event -> {
            this.fireDirtyChanged();
            this.fireCommandStackChanged();
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, (ResourceSet)resourceSet);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new E4XMIResourceFactory());
        this.resource = resourceSet.getResource(uri, true);
    }

    @Override
    public IObservableList<EObject> getRoot() {
        if (this.list != null) {
            return this.list;
        }
        this.list = E4Properties.resource(this.getEditingDomain()).observe((Object)this.resource);
        return this.list;
    }

    @Override
    public void replaceRoot(EObject eObject) {
        E4XMIResource resource = (E4XMIResource)eObject.eResource();
        HashMap<EObject, String> idMap = new HashMap<EObject, String>();
        idMap.put(eObject, resource.getID(eObject));
        TreeIterator it = EcoreUtil.getAllContents((EObject)eObject, (boolean)true);
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            resource = (E4XMIResource)o.eResource();
            idMap.put(o, resource.getID(o));
        }
        resource = (E4XMIResource)((EObject)this.list.get(0)).eResource();
        RemoveCommand cmdRemove = new RemoveCommand(this.getEditingDomain(), resource.getContents(), this.list.get(0));
        AddCommand cmdAdd = new AddCommand(this.getEditingDomain(), resource.getContents(), (Object)eObject);
        CompoundCommand cmd = new CompoundCommand(Arrays.asList(cmdRemove, cmdAdd));
        this.getEditingDomain().getCommandStack().execute((Command)cmd);
        for (Map.Entry e : idMap.entrySet()) {
            resource.setID((EObject)e.getKey(), (String)e.getValue());
        }
    }

    @Override
    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    @Override
    public boolean isSaveable() {
        return true;
    }

    @Override
    public void addModelListener(IModelResource.ModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeModelListener(IModelResource.ModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isDirty() {
        return ((BasicCommandStack)this.getEditingDomain().getCommandStack()).isSaveNeeded();
    }

    private void fireDirtyChanged() {
        for (IModelResource.ModelListener listener : this.listeners) {
            listener.dirtyChanged();
        }
    }

    private void fireCommandStackChanged() {
        for (IModelResource.ModelListener listener : this.listeners) {
            listener.commandStackChanged();
        }
    }

    @Override
    public IStatus save() {
        HashMap map = new HashMap();
        try {
            this.resource.save(map);
            BasicCommandStack commandStack = (BasicCommandStack)this.getEditingDomain().getCommandStack();
            commandStack.saveIsDone();
            this.fireDirtyChanged();
            this.fireCommandStackChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }
}

