/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.operations.LoadFailure;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.osgi.util.NLS;

public abstract class RepositoryTracker {
    public static final int STATUS_INVALID_REPOSITORY_LOCATION = 10100;
    private int artifactRepositoryFlags = 2;
    private int metadataRepositoryFlags = 2;
    private final Set<URI> reposNotFound = Collections.synchronizedSet(new LinkedHashSet());

    public abstract URI[] getKnownRepositories(ProvisioningSession var1);

    public IStatus getInvalidLocationStatus(String locationText) {
        return new Status(4, "org.eclipse.equinox.p2.operations", 10100, NLS.bind((String)Messages.RepositoryTracker_InvalidLocation, (Object)locationText), null);
    }

    public URI locationFromString(String locationString) {
        URI userLocation;
        try {
            userLocation = URIUtil.fromString((String)locationString);
        }
        catch (URISyntaxException e) {
            return null;
        }
        String uriString = URIUtil.toUnencodedString((URI)userLocation);
        if (uriString.length() > 0 && (uriString.charAt(0) == '/' || uriString.charAt(0) == File.separatorChar)) {
            return RepositoryHelper.localRepoURIHelper((URI)userLocation);
        }
        return userLocation;
    }

    public IStatus validateRepositoryLocation(ProvisioningSession session, URI location, boolean contactRepositories, IProgressMonitor monitor) {
        String locationString;
        IStatus localValidationStatus = RepositoryHelper.checkRepositoryLocationSyntax((URI)location);
        if (!(localValidationStatus.isOK() || (locationString = URIUtil.toUnencodedString((URI)location)).length() <= 0 || locationString.charAt(0) != '/' && locationString.charAt(0) != File.separatorChar)) {
            location = RepositoryHelper.localRepoURIHelper((URI)location);
            localValidationStatus = RepositoryHelper.checkRepositoryLocationSyntax((URI)location);
        }
        if (!localValidationStatus.isOK()) {
            return localValidationStatus;
        }
        return Status.OK_STATUS;
    }

    protected boolean contains(URI location, ProvisioningSession session) {
        URI[] knownRepositories;
        URI[] uRIArray = knownRepositories = this.getKnownRepositories(session);
        int n = knownRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            URI repository = uRIArray[n2];
            if (URIUtil.sameURI((URI)repository, (URI)location)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addNotFound(URI location) {
        this.reposNotFound.add(location);
    }

    public boolean hasNotFoundStatusBeenReported(URI location) {
        return this.reposNotFound.contains(location);
    }

    public void clearRepositoriesNotFound() {
        this.reposNotFound.clear();
    }

    public void clearRepositoryNotFound(URI location) {
        this.reposNotFound.remove(location);
    }

    public int getArtifactRepositoryFlags() {
        return this.artifactRepositoryFlags;
    }

    public void setArtifactRepositoryFlags(int flags) {
        this.artifactRepositoryFlags = flags;
    }

    public int getMetadataRepositoryFlags() {
        return this.metadataRepositoryFlags;
    }

    public void setMetadataRepositoryFlags(int flags) {
        this.metadataRepositoryFlags = flags;
    }

    public void reportLoadFailure(URI location, ProvisionException exception) {
        boolean repoLocationIsBad = LoadFailure.failureRepresentsBadRepositoryLocation(exception);
        if (repoLocationIsBad) {
            if (this.hasNotFoundStatusBeenReported(location)) {
                return;
            }
            this.addNotFound(location);
        }
        LogHelper.log((IStatus)exception.getStatus());
    }

    public abstract void addRepository(URI var1, String var2, ProvisioningSession var3);

    public abstract void removeRepositories(URI[] var1, ProvisioningSession var2);

    public abstract void refreshRepositories(URI[] var1, ProvisioningSession var2, IProgressMonitor var3);
}

