/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class SharedLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final int F_ERROR = 1;
    public static final int F_WARNING = 2;
    public static final int F_EXPORT = 4;
    public static final int F_EDIT = 8;
    public static final int F_BINARY = 16;
    public static final int F_EXTERNAL = 32;
    public static final int F_JAVA = 64;
    public static final int F_JAR = 128;
    public static final int F_PROJECT = 256;
    public static final int F_OPTIONAL = 512;
    public static final int F_INTERNAL = 1024;
    public static final int F_FRIEND = 2048;
    Hashtable<Object, Image> images = new Hashtable();
    ArrayList<Object> consumers = new ArrayList();
    private Image fBlankImage;

    public void connect(Object consumer) {
        if (!this.consumers.contains(consumer)) {
            this.consumers.add(consumer);
        }
    }

    public void disconnect(Object consumer) {
        this.consumers.remove(consumer);
        if (this.consumers.isEmpty()) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.consumers.isEmpty()) {
            Enumeration<Image> elements = this.images.elements();
            while (elements.hasMoreElements()) {
                elements.nextElement().dispose();
            }
            this.images.clear();
            if (this.fBlankImage != null) {
                this.fBlankImage.dispose();
                this.fBlankImage = null;
            }
        }
    }

    public Image get(ImageDescriptor desc) {
        return this.get(desc, 0);
    }

    public Image get(ImageDescriptor desc, int flags) {
        Image image;
        Object key = desc;
        if (flags != 0) {
            key = this.getKey(desc.hashCode(), flags);
        }
        if ((image = this.images.get(key)) == null) {
            image = this.createImage(desc, flags, key);
        }
        return image;
    }

    public Image get(Image image, int flags) {
        if (flags == 0) {
            return image;
        }
        String key = this.getKey(image.hashCode(), flags);
        Image resultImage = this.images.get(key);
        if (resultImage == null) {
            resultImage = this.createImage(image, flags, (Object)key);
        }
        return resultImage;
    }

    private String getKey(long hashCode, int flags) {
        return hashCode + ":" + flags;
    }

    private Image createImage(ImageDescriptor baseDesc, int flags, Object key) {
        if (flags == 0) {
            Image baseImage = baseDesc.createImage();
            this.remember(baseImage, key);
            return baseImage;
        }
        Image baseImage = this.images.get(baseDesc);
        if (baseImage == null) {
            baseImage = baseDesc.createImage();
            this.remember(baseImage, baseDesc);
        }
        ImageDescriptor lowerLeft = this.getLowerLeftOverlays(flags);
        ImageDescriptor upperRight = this.getUpperRightOverlays(flags);
        ImageDescriptor lowerRight = this.getLowerRightOverlays(flags);
        ImageDescriptor upperLeft = this.getUpperLeftOverlays(flags);
        DecorationOverlayIcon compDesc = new DecorationOverlayIcon(baseImage, new ImageDescriptor[]{upperRight, lowerRight, lowerLeft, upperLeft});
        Image image = compDesc.createImage();
        this.remember(image, key);
        return image;
    }

    private Image createImage(Image baseImage, int flags, Object key) {
        if (flags == 0) {
            return baseImage;
        }
        ImageDescriptor lowerLeft = this.getLowerLeftOverlays(flags);
        ImageDescriptor upperRight = this.getUpperRightOverlays(flags);
        ImageDescriptor lowerRight = this.getLowerRightOverlays(flags);
        ImageDescriptor upperLeft = this.getUpperLeftOverlays(flags);
        DecorationOverlayIcon compDesc = new DecorationOverlayIcon(baseImage, new ImageDescriptor[]{upperRight, lowerRight, lowerLeft, upperLeft});
        Image image = compDesc.createImage();
        this.remember(image, key);
        return image;
    }

    private void remember(Image image, Object key) {
        Image old = this.images.put(key, image);
        if (old != null) {
            old.dispose();
        }
    }

    private ImageDescriptor getLowerLeftOverlays(int flags) {
        if ((flags & 1) != 0) {
            return PDEPluginImages.DESC_ERROR_CO;
        }
        if ((flags & 2) != 0) {
            return PDEPluginImages.DESC_WARNING_CO;
        }
        return null;
    }

    private ImageDescriptor getUpperRightOverlays(int flags) {
        if ((flags & 4) != 0) {
            return PDEPluginImages.DESC_EXPORT_CO;
        }
        if ((flags & 8) != 0) {
            return PDEPluginImages.DESC_DOC_CO;
        }
        if ((flags & 0x40) != 0) {
            return PDEPluginImages.DESC_JAVA_CO;
        }
        return null;
    }

    private ImageDescriptor getLowerRightOverlays(int flags) {
        if ((flags & 0x80) != 0) {
            return PDEPluginImages.DESC_JAR_CO;
        }
        if ((flags & 0x100) != 0) {
            return PDEPluginImages.DESC_PROJECT_CO;
        }
        if ((flags & 0x200) != 0) {
            return PDEPluginImages.DESC_OPTIONAL_CO;
        }
        if ((flags & 0x400) != 0) {
            return PDEPluginImages.DESC_INTERNAL_CO;
        }
        if ((flags & 0x800) != 0) {
            return PDEPluginImages.DESC_FRIEND_CO;
        }
        return null;
    }

    private ImageDescriptor getUpperLeftOverlays(int flags) {
        if ((flags & 0x20) != 0) {
            return PDEPluginImages.DESC_EXTERNAL_CO;
        }
        if ((flags & 0x10) != 0) {
            return PDEPluginImages.DESC_BINARY_CO;
        }
        return null;
    }

    public String getColumnText(Object obj, int index) {
        return this.getText(obj);
    }

    public Image getColumnImage(Object obj, int index) {
        return this.getImage(obj);
    }

    public Image getImageFromPlugin(String bundleID, String path) {
        return ResourceLocator.imageDescriptorFromBundle((String)bundleID, (String)path).map(this::get).orElse(this.getBlankImage());
    }

    public Image getImageFromPlugin(IPluginModelBase model, String relativePath) {
        String location;
        String platform = "platform:/plugin/";
        if (relativePath.startsWith(platform)) {
            int index = (relativePath = relativePath.substring(platform.length())).indexOf(47);
            if (index == -1) {
                return null;
            }
            model = PluginRegistry.findModel((String)relativePath.substring(0, index));
            if (model == null) {
                return null;
            }
            relativePath = relativePath.substring(index + 1);
        }
        if ((location = model.getInstallLocation()) == null) {
            return null;
        }
        File pluginLocation = new File(location);
        InputStream stream = null;
        ZipFile jarFile = null;
        try {
            if (pluginLocation.isDirectory()) {
                File file = new File(pluginLocation, relativePath);
                if (file.exists()) {
                    stream = new FileInputStream(file);
                } else if (relativePath.length() > 5 && relativePath.startsWith("$nl$/") && (file = new File(pluginLocation, relativePath.substring(5))).exists()) {
                    stream = new FileInputStream(file);
                }
            } else {
                jarFile = new ZipFile(pluginLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry(relativePath);
                if (manifestEntry != null) {
                    stream = jarFile.getInputStream(manifestEntry);
                } else if (relativePath.length() > 5 && relativePath.startsWith("$nl$/") && (manifestEntry = jarFile.getEntry(relativePath.substring(5))) != null) {
                    stream = jarFile.getInputStream(manifestEntry);
                }
            }
            if (stream != null) {
                ImageDescriptor desc = ImageDescriptor.createFromImageData((ImageData)new ImageData(stream));
                Image image = this.get(desc);
                return image;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return this.getBlankImage();
    }

    public Image getBlankImage() {
        if (this.fBlankImage == null) {
            this.fBlankImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.fBlankImage;
    }
}

