/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.folding;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerLifecycle;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.tm4e.languageconfiguration.internal.folding.AbstractFoldingStrategy;
import org.eclipse.tm4e.languageconfiguration.internal.folding.IndentationFoldingStrategy;
import org.eclipse.tm4e.languageconfiguration.internal.folding.TMFoldingStrategy;

public final class CompositeFoldingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
ITextViewerLifecycle {
    private static final List<AbstractFoldingStrategy> DELEGATES = List.of(new IndentationFoldingStrategy(), new TMFoldingStrategy());

    public void initialReconcile() {
        for (AbstractFoldingStrategy delegate : DELEGATES) {
            delegate.initialReconcile();
        }
    }

    public void install(ITextViewer textViewer) {
        for (AbstractFoldingStrategy delegate : DELEGATES) {
            delegate.install(textViewer);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, @Nullable IRegion subRegion) {
        for (AbstractFoldingStrategy delegate : DELEGATES) {
            delegate.reconcile(dirtyRegion, subRegion);
        }
    }

    public void reconcile(IRegion partition) {
        for (AbstractFoldingStrategy delegate : DELEGATES) {
            delegate.reconcile(partition);
        }
    }

    public void setDocument(@Nullable IDocument document) {
        for (AbstractFoldingStrategy delegate : DELEGATES) {
            delegate.setDocument(document);
        }
    }

    public void setProgressMonitor(@Nullable IProgressMonitor monitor) {
        for (AbstractFoldingStrategy delegate : DELEGATES) {
            delegate.setProgressMonitor(monitor);
        }
    }

    public void uninstall() {
        for (AbstractFoldingStrategy delegate : DELEGATES) {
            delegate.uninstall();
        }
    }
}

