/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.spelling;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.text.spelling.CSpellingEngine;
import org.eclipse.cdt.internal.ui.text.spelling.SpellingEngine;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.ISpellingEngine;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingEngineDescriptor;

public class SpellingEngineDispatcher
implements ISpellingEngine {
    private static final String C_SPELLING_ENGINE_ID = "org.eclipse.cdt.internal.ui.text.spelling.CSpellingEngine";
    private static final IContentType CHEADER_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.cdt.core.cHeader");
    private static final IContentType CSOURCE_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.cdt.core.cSource");
    private static final IContentType CXXHEADER_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.cdt.core.cxxHeader");
    private static final IContentType CXXSOURCE_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.cdt.core.cxxSource");
    private Map<IContentType, SpellingEngine> fEngines = new HashMap<IContentType, SpellingEngine>();
    private ISpellingEngine defaultEngine;

    public SpellingEngineDispatcher() {
        CSpellingEngine engine = new CSpellingEngine();
        if (CHEADER_CONTENT_TYPE != null) {
            this.fEngines.put(CHEADER_CONTENT_TYPE, engine);
        }
        if (CSOURCE_CONTENT_TYPE != null) {
            this.fEngines.put(CSOURCE_CONTENT_TYPE, engine);
        }
        if (CXXHEADER_CONTENT_TYPE != null) {
            this.fEngines.put(CXXHEADER_CONTENT_TYPE, engine);
        }
        if (CXXSOURCE_CONTENT_TYPE != null) {
            this.fEngines.put(CXXSOURCE_CONTENT_TYPE, engine);
        }
        try {
            SpellingEngineDescriptor descriptor = EditorsUI.getSpellingService().getDefaultSpellingEngineDescriptor();
            if (!C_SPELLING_ENGINE_ID.equals(descriptor.getId())) {
                this.defaultEngine = descriptor.createEngine();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void check(IDocument document, IRegion[] regions, SpellingContext context, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        ISpellingEngine engine = this.getEngine(context.getContentType());
        if (engine == null) {
            engine = this.defaultEngine;
        }
        if (engine != null) {
            engine.check(document, regions, context, collector, monitor);
        }
    }

    private ISpellingEngine getEngine(IContentType contentType) {
        if (contentType == null) {
            return null;
        }
        if (this.fEngines.containsKey(contentType)) {
            return this.fEngines.get(contentType);
        }
        return this.getEngine(contentType.getBaseType());
    }
}

