/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.ui.filtertable.Filter;

public class StackFrameCategorizer
implements IEclipsePreferences.IPreferenceChangeListener {
    private static final String PREFIX = JDIDebugUIPlugin.getUniqueIdentifier() + ".enable_category_";
    static final IJavaStackFrame.Category CATEGORY_CUSTOM_FILTERED = new IJavaStackFrame.Category("CUSTOM_FILTERED", false);
    static final IJavaStackFrame.Category CATEGORY_SYNTHETIC = new IJavaStackFrame.Category("SYNTHETIC", true);
    static final IJavaStackFrame.Category CATEGORY_PLATFORM = new IJavaStackFrame.Category("PLATFORM", true);
    static final IJavaStackFrame.Category CATEGORY_TEST = new IJavaStackFrame.Category("TEST", false);
    static final IJavaStackFrame.Category CATEGORY_PRODUCTION = new IJavaStackFrame.Category("PRODUCTION", false);
    static final IJavaStackFrame.Category CATEGORY_LIBRARY = new IJavaStackFrame.Category("LIBRARY", true);
    static final IJavaStackFrame.Category CATEGORY_UNKNOWN = new IJavaStackFrame.Category("UNKNOWN", true);
    private Filters platform;
    private Filters custom;
    private final IPreferencesService preferenceService;
    private final IEclipsePreferences instancePreferences;

    public StackFrameCategorizer(IPreferencesService preferenceService, IEclipsePreferences instancePreferences) {
        this.preferenceService = preferenceService;
        this.instancePreferences = instancePreferences;
        this.platform = this.createActivePlatformFilters();
        this.custom = this.createActiveCustomFilters();
    }

    private Filters createActivePlatformFilters() {
        return new Filters(this.getActivePlatformStackFilter());
    }

    public String[] getActivePlatformStackFilter() {
        return this.getStringList(IJDIPreferencesConstants.PREF_ACTIVE_PLATFORM_FRAME_FILTER_LIST);
    }

    public String[] getInactivePlatformStackFilter() {
        return this.getStringList(IJDIPreferencesConstants.PREF_INACTIVE_PLATFORM_FRAME_FILTER_LIST);
    }

    public String[] getActiveCustomStackFilter() {
        return this.getStringList(IJDIPreferencesConstants.PREF_ACTIVE_CUSTOM_FRAME_FILTER_LIST);
    }

    public String[] getInactiveCustomStackFilter() {
        return this.getStringList(IJDIPreferencesConstants.PREF_INACTIVE_CUSTOM_FRAME_FILTER_LIST);
    }

    private String[] getStringList(String key) {
        return this.parseList(this.preferenceService.getString(JDIDebugUIPlugin.getUniqueIdentifier(), key, "", null));
    }

    private Filters createActiveCustomFilters() {
        return new Filters(this.getActiveCustomStackFilter());
    }

    public IJavaStackFrame.Category categorize(IJavaStackFrame frame) {
        try {
            String refTypeName = frame.getReferenceType().getName();
            if (this.isEnabled(CATEGORY_CUSTOM_FILTERED) && this.custom.match(refTypeName)) {
                return CATEGORY_CUSTOM_FILTERED;
            }
            IJavaStackFrame.Category category = this.categorizeSourceElement(frame);
            if (category == CATEGORY_PRODUCTION || category == CATEGORY_TEST) {
                return category;
            }
            if (this.isEnabled(CATEGORY_SYNTHETIC) && frame.isSynthetic()) {
                return CATEGORY_SYNTHETIC;
            }
            if (this.isEnabled(CATEGORY_PLATFORM) && this.platform.match(refTypeName)) {
                return CATEGORY_PLATFORM;
            }
            return category;
        }
        catch (DebugException de) {
            JDIDebugUIPlugin.log(de);
            return CATEGORY_UNKNOWN;
        }
    }

    private IJavaStackFrame.Category categorizeSourceElement(IJavaStackFrame frame) {
        ISourceLocator sourceLocator = frame.getLaunch().getSourceLocator();
        if (sourceLocator == null) {
            return CATEGORY_UNKNOWN;
        }
        Object source = sourceLocator.getSourceElement((IStackFrame)frame);
        if (source == null) {
            return CATEGORY_UNKNOWN;
        }
        if (source instanceof IFile) {
            IJavaProject jproj;
            IClasspathEntry cp;
            IFile file = (IFile)source;
            if (this.isEnabled(CATEGORY_TEST) && (cp = (jproj = JavaCore.create((IProject)file.getProject())).findContainingClasspathEntry((IResource)file)) != null && cp.isTest()) {
                return CATEGORY_TEST;
            }
            if (this.isEnabled(CATEGORY_PRODUCTION)) {
                return CATEGORY_PRODUCTION;
            }
        } else if (source instanceof IClassFile && this.isEnabled(CATEGORY_LIBRARY)) {
            return CATEGORY_LIBRARY;
        }
        return CATEGORY_UNKNOWN;
    }

    public boolean isEnabled(IJavaStackFrame.Category category) {
        return this.preferenceService.getBoolean(JDIDebugUIPlugin.getUniqueIdentifier(), this.getNameOfTheFlagToEnable(category), true, null);
    }

    private String getNameOfTheFlagToEnable(IJavaStackFrame.Category category) {
        return PREFIX + category.name();
    }

    public void setEnabled(IJavaStackFrame.Category category, boolean flag) {
        this.instancePreferences.putBoolean(this.getNameOfTheFlagToEnable(category), flag);
    }

    private String[] parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String prop = event.getKey();
        if (IJDIPreferencesConstants.PREF_ACTIVE_PLATFORM_FRAME_FILTER_LIST.equals(prop)) {
            this.platform = this.createActivePlatformFilters();
        } else if (IJDIPreferencesConstants.PREF_ACTIVE_CUSTOM_FRAME_FILTER_LIST.equals(prop)) {
            this.custom = this.createActiveCustomFilters();
        }
    }

    public void addTypesToActiveCustomFilters(Set<String> classNames) {
        ArrayList<String> actives = new ArrayList<String>(List.of(this.getActiveCustomStackFilter()));
        ArrayList<String> inactives = new ArrayList<String>(List.of(this.getInactiveCustomStackFilter()));
        for (String className : classNames) {
            inactives.remove(className);
            if (actives.contains(className)) continue;
            actives.add(className);
        }
        this.setCustomFilters(StackFrameCategorizer.convert(actives), StackFrameCategorizer.convert(inactives));
    }

    private void setCustomFilters(String actives, String inactives) {
        this.instancePreferences.put(IJDIPreferencesConstants.PREF_ACTIVE_CUSTOM_FRAME_FILTER_LIST, actives);
        this.instancePreferences.put(IJDIPreferencesConstants.PREF_INACTIVE_CUSTOM_FRAME_FILTER_LIST, inactives);
    }

    private void setPlatformFilters(String actives, String inactives) {
        this.instancePreferences.put(IJDIPreferencesConstants.PREF_ACTIVE_PLATFORM_FRAME_FILTER_LIST, actives);
        this.instancePreferences.put(IJDIPreferencesConstants.PREF_INACTIVE_PLATFORM_FRAME_FILTER_LIST, inactives);
    }

    void setPlatformFilters(Filter[] filters) {
        this.setPlatformFilters(StackFrameCategorizer.convert(filters, true), StackFrameCategorizer.convert(filters, false));
    }

    void setCustomFilters(Filter[] filters) {
        this.setCustomFilters(StackFrameCategorizer.convert(filters, true), StackFrameCategorizer.convert(filters, false));
    }

    private static String convert(Filter[] filters, boolean active) {
        return Stream.of(filters).filter(f -> f.isChecked() == active).map(Filter::getName).collect(Collectors.joining(","));
    }

    private static String convert(List<String> classNames) {
        return String.join((CharSequence)",", classNames);
    }

    record Filters(String[] filters) {
        boolean match(String fqcName) {
            String[] stringArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                if (filter.endsWith("*") ? fqcName.startsWith(filter.substring(0, filter.length() - 1)) : filter.equals(fqcName)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

